package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransUser;
import cn.gtmap.secondaryMarket.common.domain.vo.TransUserRoleVo;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.TransOfferVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 报价服务
 * @author zsj
 * @version v1.0, 2018/5/12
 */
@FeignClient(name = "core-server")
public interface TransOfferClient {

    /**
     * 列表
     * @param pageRequest
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/offer/getResourceOfferPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransOfferVo> getResourceOfferPage(@RequestBody PageRequest pageRequest, @RequestParam(value = "resourceId", required = false) String resourceId);


}
