package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransObligor;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 义务人服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransObligorClient {

    /**
     * 保存
     * @param transObligor
     * @return
     */
    @RequestMapping(value = "/obligor/saveObligor", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransObligor> saveObligor(@RequestBody TransObligor transObligor);

    /**
     * 修改
     * @param transObligor
     * @return
     */
    @RequestMapping(value = "/obligor/updateObligor", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransObligor> updateObligor(@RequestBody TransObligor transObligor);

    /**
     * 根据主键删除
     * @param obligorId
     * @return
     */
    @RequestMapping(value = "/obligor/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value="obligorId") String obligorId);

    /**
     * 根据主键查询
     * @param obligorId
     * @return
     */
    @RequestMapping(value = "/obligor/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransObligor selectByPrimaryKey(@RequestParam(value="obligorId") String obligorId);

    /**
     * 根据blockId进行删除
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/obligor/deleteByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByBlockId(@RequestParam(value="blockId") String blockId);

    /**
     * 根据blockId进行查询
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/obligor/getByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransObligor getByBlockId(@RequestParam(value="blockId") String blockId);

    /**
     * 根据resourceId进行删除
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/obligor/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value="resourceId") String resourceId);


    /**
     * 根据resourceId获取用逗号拼接的义务人名称
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/obligor/getYwrName", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    String getYwrName(@RequestParam(value="resourceId") String resourceId);
}
