package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransObligee;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 权利人服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransObligeeClient {

    /**
     * 保存
     * @param transObligee
     * @return
     */
    @RequestMapping(value = "/obligee/saveObligee", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransObligee> saveObligee(@RequestBody TransObligee transObligee);

    /**
     * 修改
     * @param transObligee
     * @return
     */
    @RequestMapping(value = "/obligee/updateObligee", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransObligee> updateObligee(@RequestBody TransObligee transObligee);

    /**
     * 根据主键删除
     * @param obligeeId
     * @return
     */
    @RequestMapping(value = "/obligee/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value="obligeeId") String obligeeId);

    /**
     * 根据主键查询
     * @param obligeeId
     * @return
     */
    @RequestMapping(value = "/obligee/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransObligee selectByPrimaryKey(@RequestParam(value="obligeeId") String obligeeId);

    /**
     * 根据blockId删除
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/obligee/deleteByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByBlockId(@RequestParam(value="blockId") String blockId);

    /**
     * 根据blockId查询
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/obligee/getByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransObligee getByBlockId(@RequestParam(value="blockId") String blockId);

    /**
     * 根据resourceId删除
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/obligee/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value="resourceId") String resourceId);


    /**
     * 获取用逗号拼接的权利人名称
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/obligee/getHolderName", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    String getHolderName(@RequestParam(value="resourceId") String resourceId);

}
