package cn.gtmap.secondaryMarket.common.register;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransNoticeInterface;
import cn.gtmap.secondaryMarket.common.domain.TransResource;

/**
 * 土地公告
 */
@FeignClient(name = "core-server")
public interface TransNoticeInterfaceClient {


    /**
     * 添加操作 保存公告
     * @param transNoticeInterface
     * @return
     */
    @RequestMapping(value = "/transNoticeInterface/saveTransNoticeInterface", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransNoticeInterface> saveTransNoticeInterface(@RequestBody TransNoticeInterface transNoticeInterface);


    /**
     * 更新操作 修改公告
     * @param transNoticeInterface
     * @return
     */
    @RequestMapping(value = "/transNoticeInterface/updateTransNoticeInterface", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransNoticeInterface> updateTransNoticeInterface(@RequestBody TransNoticeInterface transNoticeInterface);


    /**
     * 根据主键删除
     * @param noticeInterId
     * @return
     */
    @RequestMapping(value = "/transNoticeInterface/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransNoticeInterface> deleteByPrimaryKey(@RequestParam (value = "noticeInterId") String noticeInterId);

    /**
     * 根据noticeInterIds数组来删除
     * @param noticeInterIds
     * @return
     */
    @RequestMapping(value = "/transNoticeInterface/deleteByNoticeInterIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByNoticeInterIds(@RequestParam (value = "noticeInterIds") String[] noticeInterIds);


    /**
     * 根据主键查询实体
     * @param noticeInterId
     * @return
     */
    @RequestMapping(value = "/transNoticeInterface/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransNoticeInterface selectByPrimaryKey(@RequestParam (value = "noticeInterId") String noticeInterId);

    /**
     * 保存或新增土地公告信息
     * @param transNoticeInterface
     * @param userId
     * @param viewName
     * @return
     */
    @RequestMapping(value = "/transNoticeInterface/saveOrUpdateTransNoticeInterface", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransNoticeInterface> saveOrUpdateTransNoticeInterface(@RequestBody TransResource transResource, @RequestParam (value = "userId") String userId, @RequestParam (value = "viewName") String viewName);
}

