package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransNotice;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;

import org.apache.ibatis.annotations.Param;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 政策资讯服务
 * @author zhujunjie
 * @version v1.0, 2018/5/4
 */
@FeignClient(name = "core-server")
public interface TransNoticeClient {
	
	 /**
	  * 描述：通用分页查询-推荐使用
	  * @author 卜祥东
	  * 2022年1月7日 上午11:04:34
	  * @param paramMap
	  * @return
	  */
    @RequestMapping(value = "/notice/findTransNoticePageCommon", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransNotice> findTransNoticePageCommon(@RequestBody HashMap<String, Object> paramMap);

    /**
     * 列表页
     * @param pageRequest
     * @param title
     * @param isTop
     * @param status
     * @param zxLx
     * @return
     */
    @RequestMapping(value = "/notice/findTransNoticePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransNotice> findTransNoticePage(@RequestBody PageRequest pageRequest, @RequestParam(value = "title", required = false) String title,
                                                  @RequestParam(value = "isTop", required = false) BigDecimal isTop, @RequestParam(value = "status", required = false) BigDecimal status,
                                                  @RequestParam(value = "zxLx", required = false) Short zxLx);

    /**
     * 土地出让列表
     * @param pageRequest
     * @param title
     * @param isTop
     * @param status
     * @param zxLx
     * @return
     */
    @RequestMapping(value = "/notice/findResourceSellPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransNotice> findResourceSellPage(@RequestBody PageRequest pageRequest, @RequestParam(value = "title", required = false) String title,
                                                  @RequestParam(value = "isTop", required = false) BigDecimal isTop, @RequestParam(value = "status", required = false) BigDecimal status,
                                                  @RequestParam(value = "zxLx", required = false) Short zxLx);

    /**
     * 所有资讯类型列表
     * @param pageRequest
     * @param title
     * @param isTop
     * @param status
     * @param zxLx
     * @return
     */
    @RequestMapping(value = "/notice/findAllzxlxPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransNotice> findAllzxlxPage(@RequestBody PageRequest pageRequest, @RequestParam(value = "title", required = false) String title,
                                                   @RequestParam(value = "isTop", required = false) BigDecimal isTop, @RequestParam(value = "status", required = false) BigDecimal status,
                                                   @RequestParam(value = "zxLx", required = false) Short zxLx);


    /**
     * 添加方法
     * @param transNotice
     * @return
     */
    @RequestMapping(value = "/notice/addTransNotice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransNotice> addTransNotice(@RequestBody TransNotice transNotice);

    /**
     * 修改方法
     * @param transNotice
     * @return
     */
    @RequestMapping(value = "/notice/updateTransNotice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransNotice> updateTransNotice(@RequestBody TransNotice transNotice);

    /**
     * 删除方法
     * @param noticeId
     * @return
     */
    @RequestMapping(value = "/notice/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value = "noticeId") String noticeId);

    /**
     * 根据id数组来删除
     * @param noticeIds
     * @return
     */
    @RequestMapping(value = "/notice/deleteByPrimaryKeys", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKeys(@RequestParam(value = "noticeIds") String[] noticeIds);

    /**
     * 根据id查询实体信息
     * @param noticeId
     * @return
     */
    @RequestMapping(value = "/notice/getTransNotice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransNotice getTransNotice(@RequestParam(value = "noticeId") String noticeId);


    /**
     * 根据noticeIds进行置顶操作
     * @param noticeIds
     * @param isTop
     * @return
     */
    @RequestMapping(value = "/notice/setTopNotice", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage setTopNotice(@RequestParam(value = "noticeIds") String[] noticeIds, @RequestParam(value = "isTop", required = false) BigDecimal isTop);

}
