package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 菜单服务
 * @author zsj
 * @version v1.0, 2018/5/3
 */
@FeignClient(name = "core-server")
public interface TransMenuClient {

    /**
     * 列表
     * @return
     */
    @RequestMapping(value = "/menu/findTransMenuList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransMenu> findTransMenuList(@RequestParam(value="roleIds",required = false) List<String> roleIds,
                                      @RequestParam(value="menuLeave",required = false) Short menuLeave,
                                      @RequestParam(value="netType",required = false) Integer netType);

    /**
     * 列表
     * @return
     */
    @RequestMapping(value = "/menu/getMenuTree", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<Tree> getMenuTree(@RequestParam(value="menuValid",required = false) Short menuValid);


    /**
     * 根据menuId的list集合查询
     * @param menuIds
     * @return
     */
    @RequestMapping(value = "/menu/selectMenuByIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public List<TransMenu> selectMenuByIds(@RequestParam(value="menuIds",required = false) List menuIds);

    /**
     * 根据角色id查找对应的菜单list集合
     * @param roleId
     * @return
     */
    @RequestMapping(value = "/menu/findListByRoleId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public List<TransMenu> findListByRoleId(@RequestParam(value="roleId") String roleId);

    /**
     * 添加操作
     * @param transMenu
     * @return
     */
    @RequestMapping(value = "/menu/addMenu", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransMenu> addMenu(@RequestBody TransMenu transMenu);

    /**
     * 更新操作
     * @param transMenu
     * @return
     */
    @RequestMapping(value = "/menu/updateMenu", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransMenu> updateMenu(@RequestBody TransMenu transMenu);


    /**
     * 根据id查询实体
     * @param menuId
     * @return
     */
    @RequestMapping(value = "/menu/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public TransMenu selectByPrimaryKey(@RequestParam(value="menuId") String menuId);

    /**
     * 根据id来递归删除
     * @param menuId
     * @return
     */
    @RequestMapping(value = "/menu/deleteAllById", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage deleteAllById(@RequestParam(value="menuId") String menuId, @RequestParam(value="type") int type);


    /**
     * 根据父类id查出所有的list集合
     * @param menuParentId
     * @return
     */
    @RequestMapping(value = "/menu/findListByParentId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public List<TransMenu> findListByParentId(@RequestParam(value="menuParentId") String menuParentId);

    /**
     * 根据角色id和用户一级节点id获取对应的二三级节点
     * @param roleId
     * @param firstMenuId
     * @return
     */
    @RequestMapping(value = "/menu/findChilderList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public List<LayuiTree> findlChilderLayuiTreeList(
    			@RequestParam(value="roleId",required = false) List<String> roleIds,
    			@RequestParam(value="firstMenuId",required = false) String firstMenuId,
    			@RequestParam(value="netType",required = false) Integer netType);

}
