package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransLandTransfer;
import cn.gtmap.secondaryMarket.common.domain.vo.CountVo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 土地转让服务
 * @author zhujunjie
 * @version v1.0, 2018/5/4
 */
@FeignClient(name = "core-server")
public interface TransLandTransferClient {

    /**
     * 保存方法
     * @param transLandTransfer
     * @return
     */
    @RequestMapping(value = "/landTransfer/saveLandTransfer", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandTransfer> saveLandTransfer(@RequestBody TransLandTransfer transLandTransfer);


    /**
     * 修改方法
     * @param transLandTransfer
     * @return
     */
    @RequestMapping(value = "/landTransfer/updateLandTransfer", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandTransfer> updateLandTransfer(@RequestBody TransLandTransfer transLandTransfer);

    /**
     * 根据主键删除
     * @param transferId
     * @return
     */
    @RequestMapping(value = "/landTransfer/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value="transferId")String transferId);

    /**
     * 根据主键查询
     * @param transferId
     * @return
     */
    @RequestMapping(value = "/landTransfer/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandTransfer selectByPrimaryKey(@RequestParam(value="transferId") String transferId);

    /**
     * 根据resourceId进行删除
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/landTransfer/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value="resourceId") String resourceId);

    /**
     * 根据blockId删除
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/landTransfer/deleteByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByBlockId(@RequestParam(value="blockId") String blockId);


    @RequestMapping(value = "/landTransfer/getByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandTransfer getByBlockId(@RequestParam(value="blockId") String blockId);

    /**
     * 获取总面积或者总金额
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/landTransfer/getCountVo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    CountVo getCountVo(@RequestParam(value="resourceId") String resourceId);

}
