package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransLandMortgage;
import cn.gtmap.secondaryMarket.common.domain.vo.CountVo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 土地抵押服务
 * @author zhujunjie
 * @version 1.0, 2019/1/2 15:37
 * @description
 */
@FeignClient(name = "core-server")
public interface TransLandMortgageClient {

    @RequestMapping(value = "/landMortgage/saveLandMortgage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandMortgage> saveLandMortgage(@RequestBody TransLandMortgage record);

    @RequestMapping(value = "/landMortgage/updateLandMortgage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandMortgage> updateLandMortgage(@RequestBody TransLandMortgage record);

    @RequestMapping(value = "/landMortgage/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value="mortgageId") String mortgageId);

    @RequestMapping(value = "/landMortgage/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandMortgage selectByPrimaryKey(@RequestParam(value="mortgageId") String mortgageId);

    @RequestMapping(value = "/landMortgage/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value="resourceId") String resourceId);

//    /**
//     * 根据resourceId查询list
//     * @param resourceId
//     * @return
//     */
//    @RequestMapping(value = "/landMortgage/findListByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
//    List<TransLandMortgage> findListByResourceId(@RequestParam(value="resourceId") String resourceId);

    /**
     * 根据blockId删除
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/landMortgage/deleteByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByBlockId(@RequestParam(value="blockId") String blockId);


    @RequestMapping(value = "/landMortgage/getByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandMortgage getByBlockId(@RequestParam(value="blockId") String blockId);



//    /**
//     * 根据resourceId查询实体
//     * @param resourceId
//     * @return
//     */
//    @RequestMapping(value = "/landMortgage/getByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
//    TransLandMortgage getByResourceId(@RequestParam(value="resourceId") String resourceId);

    /**
     * 根据resourceId计算出租总金额和总面积
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/landMortgage/getCountVo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    CountVo getCountVo(@RequestParam(value="resourceId") String resourceId);
}
