package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransLandLease;
import cn.gtmap.secondaryMarket.common.domain.vo.CountVo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 土地出租服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransLandLeaseClient {

    /**
     * 保存
     * @param transLandLease
     * @return
     */
    @RequestMapping(value = "/landLease/saveLandLease", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandLease> saveLandLease(@RequestBody TransLandLease transLandLease);

    /**
     * 保存
     * @param transLandLease
     * @return
     */
    @RequestMapping(value = "/landLease/updateLandLease", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandLease> updateLandLease(@RequestBody TransLandLease transLandLease);

    /**
     * 根据主键删除
     * @param leaseId
     * @return
     */
    @RequestMapping(value = "/landLease/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value="leaseId") String leaseId);

    /**
     * 根据主键查询
     * @param leaseId
     * @return
     */
    @RequestMapping(value = "/landLease/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandLease selectByPrimaryKey(@RequestParam(value="leaseId") String leaseId);

    /**
     * 根据resourceId删除
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/landLease/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value="resourceId") String resourceId);

    /**
     * 根据blockId删除
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/landLease/deleteByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByBlockId(@RequestParam(value="blockId") String blockId);

    /**
     * 根据blockId查询实体
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/landLease/getByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandLease getByBlockId(@RequestParam(value="blockId") String blockId);

    /**
     * 根据resourceId查询
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/landLease/getByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandLease getByResourceId(@RequestParam(value="resourceId") String resourceId);

    /**
     * 根据resourceId计算出租总金额和总面积
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/landLease/getCountVo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    CountVo getCountVo(@RequestParam(value="resourceId") String resourceId);
}
