package cn.gtmap.secondaryMarket.common.register;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransLandDemand;
import cn.gtmap.secondaryMarket.common.domain.XqTongJi;
import cn.gtmap.secondaryMarket.common.domain.vo.FormVo;
import cn.gtmap.secondaryMarket.common.domain.vo.TransLandDemandVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;

/**
 * 土地需求服务
 * @author zhujunjie
 * @version v1.0, 2018/5/4
 */
@FeignClient(name = "core-server")
public interface TransLandDemandClient {

    /**
     * 列表页查询
     * @param form
     * @return
     */
    @RequestMapping(value = "/landDemand/findTransLandDemandPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransLandDemandVo> findTransLandDemandPage(@RequestBody FormVo form);



    /**
     * 添加操作 保存土地需求信息
     * @param transLandDemand
     * @return
     */
    @RequestMapping(value = "/landDemand/saveTransLandDemand", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandDemand> saveTransLandDemand(@RequestBody TransLandDemand transLandDemand);


    /**
     * 更新操作 修改土地需求信息
     * @param transLandDemand
     * @return
     */
    @RequestMapping(value = "/landDemand/updateTransLandDemand", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandDemand> updateTransLandDemand(@RequestBody TransLandDemand transLandDemand);


    /**
     * 根据主键删除
     * @param demandId
     * @return
     */
    @RequestMapping(value = "/landDemand/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandDemand> deleteByPrimaryKey(@RequestParam (value = "demandId") String demandId);


    /**
     * 根据demandId获取TransLandVo对象
     * @param demandId
     * @return
     */
    @RequestMapping(value = "/landDemand/getTransLandVo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandDemandVo getTransLandVo(@RequestParam (value = "demandId") String demandId);


    /**
     * 根据demandIds数组来删除
     * @param demandIds
     * @return
     */
    @RequestMapping(value = "/landDemand/deleteByDemandIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByDemandIds(@RequestParam (value = "demandIds") String[] demandIds);


    /**
     * 根据主键查询实体
     * @param demandId
     * @return
     */
    @RequestMapping(value = "/landDemand/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandDemand selectByPrimaryKey(@RequestParam (value = "demandId") String demandId);

    /**
     * 根据行政区来进行统计
     * @param regionLevel
     * @return
     */
    @RequestMapping(value = "/landDemand/getDemandCntByCity", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<XqTongJi> getDemandCntByCity(@RequestParam(value="regionLevel",required = false)Integer regionLevel);
    
    /**
     * 查询最大流水号
     * @return
     */
    @RequestMapping(value = "/landDemand/selectMaxLsh", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    BigDecimal selectMaxLsh();
    
    /**
     * 获取接口待更新数据
     * @return
     */
    @RequestMapping(value = "/landDemand/getTransLandDemandUpList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransLandDemand> getTransLandDemandUpList();
}

