package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransLandDeal;
import cn.gtmap.secondaryMarket.common.domain.vo.FormVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 土地交易注册服务
 * @author zhujunjie
 * @date 2018-5-21 14:05:39
 */
@FeignClient(name = "core-server")
public interface TransLandDealClient {

    /**
     * 新增或者修改
     * @param transLandDeal
     * @return
     */
    @RequestMapping(value = "/landDeal/modifyTransLandDeal", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransLandDeal> modifyTransLandDeal(@RequestBody TransLandDeal transLandDeal);


    /**
     * 根据主键删除
     * @param dealId
     * @return
     */
    @RequestMapping(value = "/landDeal/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value = "dealId") String dealId);


    /**
     * 根据主键查询实体
     * @param dealId
     * @return
     */
    @RequestMapping(value = "/landDeal/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandDeal selectByPrimaryKey(@RequestParam(value = "dealId") String dealId);


    /**
     * 根据resourceId查询实体信息
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/landDeal/getByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransLandDeal getByResourceId(@RequestParam(value = "resourceId") String resourceId);


    /**
     * 列表页查询
     * @param form
     * @return
     */
    @RequestMapping(value = "/landDeal/findTransLandDealPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse findTransLandDealPage(@RequestBody FormVo form);
}
