package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransHouseDetail;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 房屋抵押信息
 * @author liuq
 * @version v1.0, 2018/7/10
 */
@FeignClient(name = "core-server")
public interface TransHouseDetailClient {

    /**
     * 根据id删除实体
     * @param houseDetailId
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value = "houseDetailId") String houseDetailId);

    /**
     * 根据resourceId删除实体
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value = "resourceId") String resourceId);

    /**
     * 新增
     * @param record
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/insert", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage insert(@RequestBody TransHouseDetail record);

    /**
     * 保存全部信息
     * @param records
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/insertAll", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage insertAll(@RequestBody List<TransHouseDetail> records);

    /**
     * 新增
     * @param record
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/insertSelective", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage insertSelective(@RequestBody TransHouseDetail record);

    /**
     * 根据id查询实体
     * @param houseDetailId
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransHouseDetail> selectByPrimaryKey(@RequestParam(value = "houseDetailId") String houseDetailId);

    /**
     * 根据resourceId查询实体
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/selectByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransHouseDetail> selectByResourceId(@RequestParam(value = "resourceId") String resourceId);

    /**
     * 更新
     * @param record
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/updateByPrimaryKeySelective", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage updateByPrimaryKeySelective(@RequestBody TransHouseDetail record);

    /**
     * 更新
     * @param record
     * @return
     */
    @RequestMapping(value = "/transHouseDetail/updateByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage updateByPrimaryKey(@RequestBody TransHouseDetail record);

}
