package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransFile;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;


/**
 * 服务指南
 * @author cxm
 * @version v1.0, 2018/5/30
 */
@FeignClient(name = "core-server")
public interface TransFileClient {

    /**
     * 列表页
     * @param pageRequest
     * @param fileName
     * @param fileClassify
     * @return
     */
    @RequestMapping(value = "/file/findTransFilePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransFile> findTransFilePage(@RequestBody PageRequest pageRequest, @RequestParam(value = "fileName", required = false) String fileName,
                                                @RequestParam(value = "fileClassify", required = false) Short fileClassify);

    /**
     * 添加服务指南
     * @param transFile
     * @return
     */
    @RequestMapping(value = "/file/saveTransFile", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransFile> saveTransFile(@RequestBody TransFile transFile);

    /**
     * 修改方法
     * @param transFile
     * @return
     */
    @RequestMapping(value = "/file/updateTransFile", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransFile> updateTransFile(@RequestBody TransFile transFile);

    /**
     * 删除方法
     * @param fileId
     * @return
     */
    @RequestMapping(value = "/file/deleteByFileId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByFileId(@RequestParam(value = "fileId") String fileId);

    /**
     * 根据id数组来删除
     * @param fileIds
     * @return
     */
    @RequestMapping(value = "/file/deleteByFileIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByFileIds(@RequestParam(value = "fileIds") String[] fileIds);

    /**
     * 根据id查询实体信息
     * @param fileId
     * @return
     */
    @RequestMapping(value = "/file/getByFileId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransFile getByFileId(@RequestParam(value = "fileId") String fileId);

}
