package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 数据字典注册服务
 * @author zhujunjie
 * @date 2018-5-14 12:19:40
 */
@FeignClient(name = "core-server")
public interface TransDataDictionaryClient {

    /**
     * 根据条件查询list集合
     * @param dataFcode 父类编码
     * @param dataLevel 等级
     * @return
     */
    @RequestMapping(value = "/dataDictionary/findTransDataDictionaryList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransDataDictionary> findTransDataDictionaryList(@RequestParam(value = "dataFcode", required = false) String dataFcode, @RequestParam(value = "dataLevel", required = false) BigDecimal dataLevel);

    /**
     * 根据编码和父类编码查询实体信息
     * @param dataCode 编码
     * @param dataFcode 父类编码
     * @param dataLevel 等级
     * @return
     */
    @RequestMapping(value = "/dataDictionary/getDateByCodeAndFcode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransDataDictionary getDateByCodeAndFcode(@RequestParam(value = "dataCode", required = false) String dataCode, @RequestParam(value = "dataFcode", required = false) String dataFcode,
                                              @RequestParam(value = "dataLevel", required = false) Short dataLevel);
    /**
     * 根据名称和父类编码查询实体信息
     * @param dataCode 名称
     * @param dataFcode 父类编码
     * @param dataLevel 等级
     * @return
     */
    @RequestMapping(value = "/dataDictionary/getDateByName", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransDataDictionary getDateByName(@RequestParam(value = "dataName", required = false) String dataName, @RequestParam(value = "dataFcode", required = false) String dataFcode,
    		@RequestParam(value = "dataLevel", required = false) Short dataLevel);


    /**
     * 根据'a,b'这样的dataCodes将name查询出来并用逗号拼接
     * @param dataCodes
     * @param dataType
     * @return
     */
    @RequestMapping(value = "/dataDictionary/getByDateCodes", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    String getByDateCodes(@RequestParam(value = "dataCodes") List dataCodes, @RequestParam(value = "dataType") String dataType);

    /**
     * 树形列表
     * @return
     */
    @RequestMapping(value = "/dataDictionary/getDataTree", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<Tree> getDataTree();

    /**
     * 根据id查询实体
     * @param dataId
     * @return
     */
    @RequestMapping(value = "/dataDictionary/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public TransDataDictionary selectByPrimaryKey(@RequestParam(value="dataId") String dataId);

    /**
     * 添加操作
     * @param transDataDictionary
     * @return
     */
    @RequestMapping(value = "/dataDictionary/addTransDataDictionary", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransDataDictionary> addTransDataDictionary(@RequestBody TransDataDictionary transDataDictionary);

    /**
     * 根据id来递归删除
     * @param dataId
     * @return
     */
    @RequestMapping(value = "/dataDictionary/deleteAllById", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage deleteAllById(@RequestParam(value="dataId") String dataId, @RequestParam(value="type") int type);

    /**
     * 更新操作
     * @param transDataDictionary
     * @return
     */
    @RequestMapping(value = "/dataDictionary/updateTransDataDictionary", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransDataDictionary> updateTransDataDictionary(@RequestBody TransDataDictionary transDataDictionary);

    /**
     * 根据code查询列表
     * @return
     */
    @RequestMapping(value = "/dataDictionary/findTransDataDictionaryListByCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransDataDictionary> findTransDataDictionaryListByCode(@RequestParam(value="dataCode") String dataCode);

    /**
     * 根据code查询所有子级
     * @return
     */
    @RequestMapping(value = "/dataDictionary/findChildrenListByCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransDataDictionary> findChildrenListByCode(@RequestParam(value="dataCode") String dataCode);

    /**
     * 根据父类节点id查找子类集合
     * @param dataFId
     * @return
     */
    @RequestMapping(value = "/dataDictionary/findListByParentId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransDataDictionary> findListByParentId(@RequestParam(value="dataFId") String dataFId);


    /**
     * 根据dataCode查询所有子级layuitree
     * @param dataCode
     * @return
     */
    @RequestMapping(value = "/dataDictionary/findLayuiTreeListByCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<LayuiTree> findLayuiTreeListByCode(@RequestParam(value="dataCode") String dataCode);


    /**
     * 根据父类总编码和子类编码获取实体
     * @param dataCode
     * @param dataFcode
     * @return
     */
    @RequestMapping(value = "/dataDictionary/getByCodeAndFcode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransDataDictionary getByCodeAndFcode(@RequestParam(value="dataCode") String dataCode,
                                              @RequestParam(value="dataFcode") String dataFcode);
}
