package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.TransCrgg;
import cn.gtmap.secondaryMarket.common.domain.form.TransCrggForm;
import cn.gtmap.secondaryMarket.common.domain.vo.TransCrggVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 出让公告服务
 * @author zhujunjie
 * @version v1.0, 2018/5/4
 */
@FeignClient(name = "core-server")
public interface TransCrggClient {

    /**
     * 列表页
     * @param form
     * @return
     */
   @RequestMapping(value = "/crgg/findTransCrggPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
   PageResponse<TransCrggVo> findTransCrggPage(@RequestBody TransCrggForm form);

    /**
     * 修改
     *
     * @param transCrgg
     * @return
     */
    @RequestMapping(value = "/crgg/updateTransCrgg", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransCrgg> updateTransCrgg(@RequestBody TransCrgg transCrgg);

    /**
     * 根据id删除数据
     *
     * @param ggId
     * @return
     */
    @RequestMapping(value = "/crgg/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransCrgg> deleteByPrimaryKey(@RequestParam(value = "ggId") String ggId);

    /**
     * 根据id获取对象
     *
     * @param ggId
     * @return
     */
    @RequestMapping(value = "/crgg/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransCrgg selectByPrimaryKey(@RequestParam(value = "ggId") String ggId);

    /**
     * 保存出让公告对象
     * @param transCrgg 出让公告
     * @return ResponseMessage<TransCrgg>
     */
    @RequestMapping(value = "/crgg/saveTransCrgg", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransCrgg> saveTransCrgg(@RequestBody TransCrgg transCrgg);
}
