package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransCount;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 土地竞价服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransCountClient {

    /**
     * 添加方法
     * @param transCount
     * @return
     */
    @RequestMapping(value = "/transCount/insert", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransCount> insert(@RequestBody TransCount transCount);


    /**
     * 查询总数目
     * @return
     */
    @RequestMapping(value = "/transCount/findCountNum", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public int findCountNum();
}
