package cn.gtmap.secondaryMarket.common.register;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransContractSt;
import cn.gtmap.secondaryMarket.common.domain.form.TransContractStForm;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;

/**
 * @描述 省厅合同接口 
 * @作者 卜祥东
 * @创建日期 2021年7月1日 
 * @创建时间 下午2:55:23
 * @版本号 V 1.0
 */
@FeignClient(name = "core-server")
public interface TransContractStClient {

    /**
     * 保存或者修改
     * @param contractTemplate
     * @return
     */
    @RequestMapping(value = "/contractSt/saveOrUpdate", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransContractSt> saveOrUpdate(@RequestBody TransContractSt transContractSt);

    /**
	 * 描述：上报合同数据到省厅(管理端审核合同用)
	 * 2021年5月20日 下午3:28:26
	 * @param contractId
	 * @param contractStatus(合同状态)
	 * @param approvalResults(审核失败原因)
	 */
    @RequestMapping(value = "/contractSt/reportContract", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void reportContract(@RequestParam(value="contractId")String contractId);
    
    /**
     * 根据主键查询
     * @param templateId
     * @return
     */
    @RequestMapping(value = "/contractSt/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransContractSt selectByPrimaryKey(@RequestParam(value="id") String id);
    
    /**
     * 根据地块id查询
     * @param templateId
     * @return
     */
    @RequestMapping(value = "/contractSt/selectByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransContractSt selectByResourceId(@RequestParam(value="resourceId") String resourceId);

    /**
     * 分页查询
     * @param form
     * @return
     */
    @RequestMapping(value = "/contractSt/findPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransContractSt> findPage(@RequestBody TransContractStForm transContractStForm);


    /**
     * 根据id批量删除
     * @param ids
     * @return
     */
    @RequestMapping(value = "/contractSt/deleteByIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByTemplateIds(@RequestParam(value="ids") String[] ids);
}
