package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransContractLog;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author: zhujunjie
 * @date: 2019/6/13
 **/
@FeignClient(name = "core-server")
public interface TransContractLogClient {

    @RequestMapping(value = "/transContractLog/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransContractLog> save(@RequestBody TransContractLog record);

    @RequestMapping(value = "/transContractLog/selectCount", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    int selectCount(@RequestParam(value = "currentYear", required = false)String currentYear,@RequestParam(value = "type", required = false)String type);
}
