package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransContract;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author: zhujunjie
 * @date: 2019/6/10
 **/
@FeignClient(name = "core-server")
public interface TransContractClient {

    @RequestMapping(value = "/transContract/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransContract selectByPrimaryKey(@RequestParam(value = "contractId") String contractId);

    @RequestMapping(value = "/transContract/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage save(@RequestBody TransContract transContract);

    @RequestMapping(value = "/transContract/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage update(@RequestBody TransContract transContract);

    @RequestMapping(value = "/transContract/getByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransContract getByResourceId(@RequestParam(value = "resourceId") String resourceId);

    /**
     * 根据resourceId进行删除合同表
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/transContract/getByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value = "resourceId") String resourceId);
}
