package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransConsultant;
import cn.gtmap.secondaryMarket.common.domain.form.ConsultantForm;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 预约信息服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransConsultantClient {


    /**
     * 保存
     * @param transConsultant
     * @return
     */
    @RequestMapping(value = "/consultant/addTransConsultant", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransConsultant> addTransConsultant(@RequestBody TransConsultant transConsultant);


    /**
     * 修改
     * @param transConsultant
     * @return
     */
    @RequestMapping(value = "/consultant/updateTransConsultant", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransConsultant> updateTransConsultant(@RequestBody TransConsultant transConsultant);

    /**
     * 咨询列表
     * @param form
     * @return
     */
    @RequestMapping(value = "/consultant/consultantList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransConsultant> consultantList(@RequestBody ConsultantForm form);

    /**
     * 根据consultantId查找咨询实体
     * @param consultantId
     * @return
     */
    @RequestMapping(value = "/consultant/findConsultantByConsultId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransConsultant findConsultantByConsultId(@RequestParam(value = "consultantId") String consultantId);

    /**
     * 删除咨询
     * @param consultantId
     * @return
     */
    @RequestMapping(value = "/consultant/deleteTransConsultant", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteTransConsultant(@RequestParam(value = "consultantId") String consultantId);

}
