package cn.gtmap.secondaryMarket.common.register;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransConfigure;
import cn.gtmap.secondaryMarket.common.domain.form.ConfigureForm;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;

/**
 * 配置表服务
 * @author: zhujunjie
 * @DATE: 2019/4/22
 **/
@FeignClient(name = "core-server")
public interface TransConfigureClient {

    @RequestMapping(value = "/transConfigure/saveConfigure", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransConfigure> saveConfigure(@RequestBody TransConfigure transConfigure);

    @RequestMapping(value = "/transConfigure/updateConfigure", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransConfigure> updateConfigure(@RequestBody TransConfigure transConfigure);

    @RequestMapping(value = "/transConfigure/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransConfigure selectByPrimaryKey(@RequestParam(value="configureId") String configureId);

    @RequestMapping(value = "/transConfigure/deleteByConfigureIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByConfigureIds(@RequestParam(value="configureIds") String[] configureIds);

    @RequestMapping(value = "/transConfigure/findConfigurePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransConfigure> findConfigurePage(@RequestBody ConfigureForm form);

    @RequestMapping(value = "/transConfigure/findConfigureList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransConfigure> findConfigureList();
    
    @RequestMapping(value = "/transConfigure/getConfigureByKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransConfigure getConfigureByKey(@RequestParam(value = "key", required = false) String key);
}
