package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransBlock;
import cn.gtmap.secondaryMarket.common.domain.vo.TransBlockVo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 地块服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransBlockClient {

    /**
     * 保存
     * @param transBlock
     * @return
     */
    @RequestMapping(value = "/block/saveBlock", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBlock> saveBlock(@RequestBody TransBlock transBlock);


    /**
     * 批量保存地块日志方法
     * @param blockList
     * @return
     */
    @RequestMapping(value = "/block/saveBlockList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage saveBlockList(@RequestBody List<TransBlock> blockList);

    /**
     * 修改
     * @param transBlock
     * @return
     */
    @RequestMapping(value = "/block/updateBlock", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBlock> updateBlock(@RequestBody TransBlock transBlock);

    /**
     * 根据主键删除
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/block/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value="blockId") String blockId);

    /**
     * 根据主键查询
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/block/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransBlock selectByPrimaryKey(@RequestParam(value="blockId") String blockId);

    /**
     * 根据resourceId查询
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/block/findListByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransBlock> findListByResourceId(@RequestParam(value="resourceId") String resourceId);


    /**
     * 根据resourceId查询实体
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/block/getByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransBlock getByResourceId(@RequestParam(value="resourceId") String resourceId);

    /**
     * 根据resourceId删除
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/block/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value="resourceId") String resourceId);


    /**
     * 根据resourceId查询blockVolist集合
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/block/findBlockVoList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransBlockVo> findBlockVoList(@RequestParam(value="resourceId") String resourceId);


    /**
     * 根据resourceId查询blockVo实体
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/block/getBlockVoByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransBlockVo getBlockVoByResourceId(@RequestParam(value="resourceId") String resourceId);


    /**
     * 根据blockId查询blockVo实体
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/block/getBlockVoByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransBlockVo getBlockVoByBlockId(@RequestParam(value="blockId") String blockId);
}
