package cn.gtmap.secondaryMarket.common.register;

import java.util.HashMap;
import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransBdc;
import cn.gtmap.secondaryMarket.common.domain.TransNotice;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;

/**
 * @描述 不动产管理服务-客户端
 * @作者 卜祥东
 * @创建日期 2022年1月17日 
 * @创建时间 下午3:20:27
 * @版本号 V 1.0
 */
@FeignClient(name = "core-server")
public interface TransBdcglClient {
	
	@RequestMapping(value = "/bdcgl/findTransBdcPageCommon", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	PageResponse<TransBdc> findTransBdcPageCommon(@RequestBody HashMap<String, Object> paramMap);
	
	@RequestMapping(value = "/bdcgl/findTransBdcListCommon", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	List<TransBdc> findTransBdcListCommon(@RequestBody HashMap<String, Object> paramMap);
	
	@RequestMapping(value = "/bdcgl/insertTransbdc", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBdc> insertTransbdc(@RequestBody TransBdc transBdc);
	
	@RequestMapping(value = "/bdcgl/updateTransBdc", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBdc> updateTransBdc(@RequestBody TransBdc transBdc);
    
    @RequestMapping(value = "/bdcgl/deleteTransBdcCommon", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteTransBdcCommon(@RequestBody HashMap<String, Object> paramMap);

}
