package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransAutograph;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 签名图片服务
 * @author zhujunjie
 * @date 2018-6-22 17:30:50
 */
@FeignClient(name = "core-server")
public interface TransAutographClient {

    /**
     * 根据userId查询用户签名信息
     * @param userId
     * @return
     */
    @RequestMapping(value = "/autograph/getByUserId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransAutograph getByUserId(@RequestParam(value = "userId") String userId);

    /**
     * 对签名图片进行保存和修改
     * @param transAutograph
     * @return
     */
    @RequestMapping(value = "/autograph/modify", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage modify(@RequestBody TransAutograph transAutograph);
}
