package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransApprovalLog;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 审批意见日志
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransApprovalLogClient {

    /**
     * 保存方法
     * @param resourceId
     * @param taskDefKey
     * @param userId
     * @return
     */
    @RequestMapping(value = "/approvalLog/saveApprovalLog", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransApprovalLog> saveApprovalLog(@RequestParam(value = "resourceId", required = false) String resourceId,
                                                      @RequestParam(value = "taskDefKey", required = false) String taskDefKey, @RequestParam(value = "userId", required = false) String userId);

    /**
     * 根据条件查询list集合
     * @param resourceId
     * @param taskDefKey
     * @return
     */
    @RequestMapping(value = "/approvalLog/selectByCondition", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransApprovalLog> selectByCondition(@RequestParam(value = "resourceId", required = false) String resourceId, @RequestParam(value = "taskDefKey", required = false) String taskDefKey);
}
