package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransApproval;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 审批意见
 *
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransApprovalClient {

	/**
	 * 根据id来删除
	 *
	 * @param approvalId
	 * @return
	 */
	@RequestMapping(value = "/approval/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	ResponseMessage deleteByPrimaryKey(@RequestParam(value = "approvalId") String approvalId);

	/**
	 * 根据id来查询实体
	 *
	 * @param approvalId
	 * @return
	 */
	@RequestMapping(value = "/approval/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	TransApproval selectByPrimaryKey(@RequestParam(value = "approvalId") String approvalId);

	/**
	 * 根据resourceId查询实体
	 *
	 * @param resourceId
	 * @return
	 */
	@RequestMapping(value = "/approval/getByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	TransApproval getByResourceId(@RequestParam(value = "resourceId") String resourceId);

	/**
	 * 根据oddNumber查询实体
	 *
	 * @param oddNumber
	 * @return
	 */
	@RequestMapping(value = "/approval/getByOddNumber", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	TransApproval getByOddNumber(@RequestParam(value = "oddNumber") String oddNumber);

	/**
	 * 修改或者保存实体类
	 *
	 * @param transApproval
	 * @return
	 */
	@RequestMapping(value = "/approval/modify", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	ResponseMessage<TransApproval> modify(@RequestBody TransApproval transApproval);
}
