package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.constants.sign.FeignMultipartSupportConfig;
import cn.gtmap.secondaryMarket.common.domain.SysFile;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.List;

/**
 * @描述 本地文件中心服务
 * @作者 卜祥东
 * @创建日期 2022年1月28日
 * @创建时间 上午10:35:48
 * @版本号 V 1.0
 */
@FeignClient(name = "core-server", configuration = FeignMultipartSupportConfig.class)
public interface StorageClient {

	@RequestMapping(value = "/storage/saveSysFile", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	SysFile saveSysFile(@RequestBody SysFile sysFile);

	@RequestMapping(value = "/storage/uploadAndSave", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
	SysFile uploadAndSave(@RequestPart("file") MultipartFile file, @RequestParam("parentId") String parentId);

	@RequestMapping(value = "/storage/copySysFile", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
	void copySysFile(@RequestParam("fileKey") String fileKey, @RequestParam("newFileKey") String newFileKey);

	@RequestMapping(value = "/storage/upload", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
	SysFile upload(@RequestPart("file") MultipartFile file);

	@RequestMapping(value = "/storage/getSysFile", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	SysFile getSysFile(@RequestParam("fileId") String fileId);

	@RequestMapping(value = "/storage/getFile", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	File getFile(@RequestBody SysFile sysFile);

	@RequestMapping(value = "/storage/getSysFileList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	List<SysFile> getSysFileList(@RequestParam("fileKey") String fileKey,@RequestParam("fileType") Integer fileType);

	@RequestMapping(value = "/storage/getListByParentId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	List<SysFile> getListByParentId(@RequestParam("parentId") String parentId);

	@RequestMapping(value = "/storage/getCountByParentId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	int getCountByParentId(@RequestParam("parentId") String parentId);

	@RequestMapping(value = "/storage/getCountByFileKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	int getCountByFileKey(@RequestParam("fileKey") String fileKey);

	@RequestMapping(value = "/storage/deleteFilesByKeys", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	void deleteFilesByKeys(@RequestParam("fileKeys") String fileKeys);

	@RequestMapping(value = "/storage/deleteFilesByNodeIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	void deleteFilesByNodeIds(@RequestParam("nodeIds") String nodeIds);

	@RequestMapping(value = "/storage/getStorePath", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	String getStorePath();
}
