package cn.gtmap.secondaryMarket.common.register;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.SmsCode;

/**
 * 短信状态
 */
@FeignClient(name = "core-server")
public interface SmsCodeClient {


    /**
     * 添加操作
     * @param smsCode
     * @return
     */
    @RequestMapping(value = "/smsCode/saveSmsCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<SmsCode> saveSmsCode(@RequestBody SmsCode smsCode);


    /**
     * 更新操作
     * @param smsCode
     * @return
     */
    @RequestMapping(value = "/smsCode/updateSmsCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<SmsCode> updateSmsCode(@RequestBody SmsCode smsCode);


    /**
     * 根据主键删除
     * @param smsId
     * @return
     */
    @RequestMapping(value = "/smsCode/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<SmsCode> deleteByPrimaryKey(@RequestParam (value = "smsId") String smsId);

    /**
     * 根据主键查询实体
     * @param smsId
     * @return
     */
    @RequestMapping(value = "/smsCode/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    SmsCode selectByPrimaryKey(@RequestParam (value = "smsId") String smsId);

}

