package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * Created by Administrator on 2017/2/23.
 */
@FeignClient(name = "search-server")
public interface LogClient {

    /**
     * 保存es
     * @param object
     * @param id
     * @param type
     * @param mappings
     */
    @RequestMapping(value = "/secondMarket/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void save(@RequestBody Object object, @RequestParam(value = "id", required = false) String id, @RequestParam(value = "type", required = false) String type, @RequestParam(value = "mappings", required = false) String mappings);

    /**
     * 根据id来删除es数据
     * @param id
     * @param type
     */
    @RequestMapping(value = "/secondMarket/delete", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void delete(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "type", required = false) String type);

    @RequestMapping(value = "/secondMarket/searchByFeature", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    Map searchByFeature(@RequestParam("condition")String condition, @RequestParam("type") String type, @RequestParam("field") String field);

    @RequestMapping(value = "/secondMarket/searchNum", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    Map searchNum(@RequestParam("condition")String condition, @RequestParam("type") String type, @RequestParam("field") String field);
    
    @RequestMapping(value = "/secondMarket/search", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse search(@RequestParam(value = "type", required = false) String type, @RequestParam(value = "condition", required = false) String condition, @RequestBody PageRequest pageRequest);
}