package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.workflow.HistoricProcessInstance;
import cn.gtmap.secondaryMarket.common.domain.workflow.HistoricVariableInstance;
import cn.gtmap.secondaryMarket.common.domain.workflow.Task;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 工作流服务
 *
 * @author zhujunjie
 * @date 2018-5-15 11:29:28
 */
@FeignClient(name = "workflow-app")
public interface LandWorkFlowClient {

	/**
	 * 根据工作流key启动工作流 获取流程实例id
	 *
	 * @param workflowKey
	 * @param variables
	 * @param businessKey
	 * @return
	 */
	@RequestMapping(value = "/landWorkFlow/startProcessByKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public String startProcessByKey(@RequestParam(value = "workflowKey") String workflowKey, @RequestBody Map<String, Object> variables,
	                                @RequestParam(value = "businessKey", required = false) String businessKey);

	/**
	 * 查询个人待办列表
	 *
	 * @param assignee
	 * @param pageable
	 * @return
	 */
	@RequestMapping(value = "/landWorkFlow/queryTasks", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public Page<Task> queryTasks(@RequestParam(value = "assignee") String assignee, PageRequest pageable);


	/**
	 * 查询个人已办实例
	 *
	 * @param userName
	 * @param pageable
	 * @return
	 */
	@RequestMapping(value = "/landWorkFlow/findHistoryProcessInstance", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public Page<HistoricProcessInstance> findHistoryProcessInstance(@RequestParam(value = "userName") String userName, Pageable pageable);

	/**
	 * 办理个人任务
	 *
	 * @param processInstanceId
	 * @param variables
	 */
	@RequestMapping(value = "/landWorkFlow/completeTaskByProcessId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public void completeTaskByProcessId(@RequestParam(value = "processInstanceId") String processInstanceId, @RequestBody Map<String, Object> variables, @RequestParam(value = "userName", required = false) String userName, @RequestParam(value = "taskId") String taskId);


	/**
	 * 获取流程图
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/landWorkFlow/getTaskTraceDiagram", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public byte[] getTaskTraceDiagram(@RequestParam(value = "processInstanceId") String processInstanceId);

	/**
	 * 获取历史流程变量
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/landWorkFlow/findHistoryProcessVariables", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public List<HistoricVariableInstance> findHistoryProcessVariables(@RequestParam(value = "processInstanceId") String processInstanceId);


	/**
	 * 查看流程是否结束
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/landWorkFlow/isProcessOver", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public boolean isProcessOver(@RequestParam(value = "processInstanceId") String processInstanceId);

	/**
	 * 给任务添加批注信息
	 *
	 * @param processInstanceId
	 * @param type
	 * @param comment
	 */
	@RequestMapping(value = "/landWorkFlow/addTaskComment", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public void addTaskComment(@RequestParam(value = "processInstanceId") String processInstanceId, @RequestParam(value = "type", required = false) String type,
	                           @RequestParam(value = "comment", required = false) String comment, @RequestParam(value = "taskId") String taskId);


	/**
	 * 根据流程实例删除流程
	 *
	 * @param processInstanceId
	 */
	@RequestMapping(value = "/landWorkFlow/deleteProcessInstance", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public void deleteProcessInstance(@RequestParam(value = "processInstanceId") String processInstanceId);

	/**
	 * 根据流程实例id获取流程节点id
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/landWorkFlow/getUserKeyByProcessInstanceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public String getUserKeyByProcessInstanceId(@RequestParam(value = "processInstanceId") String processInstanceId);

	/**
	 * 描述：根据流程实例id查询taskid
	 * @author 卜祥东
	 * 2021年12月22日 下午3:59:10
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/landWorkFlow/getTaskIdByProcessInstanceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public String getTaskIdByProcessInstanceId(@RequestParam(value = "processInstanceId") String processInstanceId);
	
	/**
	 * @作者 王建明
	 * @创建日期 2021/11/13 上午9:43
	 * @描述 获取流程示例信息
	 */
	@RequestMapping(value = "/landWorkFlow/getProcessInstanceById", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public String getProcessInstanceById(@RequestParam(value = "processInstanceId") String processInstanceId);

	/**
	 * @作者 王建明
	 * @创建日期 2021/11/13 下午9:18
	 * @描述 获取任务节点数据
	 */
	@RequestMapping(value = "/landWorkFlow/getTaskById", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public String getTaskById(@RequestParam(value = "taskId") String processInstanceId);
	
	/**
	 * @param taskId     当前任务ID
	 * @param variables  流程变量
	 * @param activityId 流程转向执行任务节点ID<br>
	 *                   此参数为空，默认为提交操作
	 * @throws Exception
	 */
	@RequestMapping(value = "/workflow/commitProcess", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public ResponseMessage commitProcess(@RequestParam(value = "taskId") String taskId, @RequestBody Map<String, Object> variables, @RequestParam(value = "activityId") String activityId);
}
