package cn.gtmap.secondaryMarket.common.register;


import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransResource;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.FLTransResource;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.TransNumber;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.TransResourceApply;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.TransUserApplyInfo;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.TransUserUnion;
import cn.gtmap.secondaryMarket.common.domain.form.FLTransResourceForm;

/**
 * 交易部分
 * @author lq
 * @version v1.0, 2018/08/09
 */
@FeignClient(name = "fl-core-server")
public interface FirstLevelClient {

    /**
     * 获得出让地块
     * @param resourceId 地块Id
     * @return
     */
    @RequestMapping(value = "/client/resource/getTransResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    FLTransResource getTransResource(@RequestParam("resourceId") String resourceId);


    /**
     * 保存出让地块对象
     * @param FLTransResource 出让地块
     * @return ResponseMessage<FLTransResource>
     */
    @RequestMapping(value = "/client/resource/saveTransResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<FLTransResource> saveTransResource(@RequestBody FLTransResource FLTransResource);

    /**
     * 批量保存出让地块对象
     * @param resources 出让地块
     * @return ResponseMessage<FLTransResource>
     */
    @RequestMapping(value = "/client/resource/saveTransResources", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<FLTransResource> saveTransResources(@RequestBody List<FLTransResource> resources);


    /**
     * 获得出让地块
     * @param resourceCode 地块Code
     * @return
     */
    @RequestMapping(value = "/client/resource/getTransResourceByCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    FLTransResource getTransResourceByCode(@RequestParam("resourceCode") String resourceCode);
    
    /**
     * 获得出让地块
     * @param relationId relationId
     * @return
     */
    @RequestMapping(value = "/client/resource/getTransResourceByRelationId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    FLTransResource getTransResourceByRelationId(@RequestParam("relationId") String relationId);

    /**
     * 获得出让地块集合
     * @param resourceCode 地块Code
     * @return
     */
    @RequestMapping(value = "/client/resource/getResourcesByCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<FLTransResource> getResourcesByCode(@RequestParam("resourceCode") String resourceCode);


    /**
     * 根据公告Id获取公告地块
     * @param ggId
     * @return
     */
    @RequestMapping(value = "/client/resource/findTransResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<FLTransResource> findTransResource(@RequestParam("ggId") String ggId);

    /**
     * 获取全部地块
     * @return
     */
    @RequestMapping(value = "/client/resource/findAllTransResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<FLTransResource> findAllTransResource();

    /**
     * 分页查询
     * @return
     */
    @RequestMapping(value = "/client/resource/findTransResourcePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    Page<FLTransResource> findTransResourcePage(@RequestBody FLTransResourceForm form);

    /**
     * 根据公告Id获取公告地块,按XS_index排序
     * @param ggId
     * @return
     */
    @RequestMapping(value = "/client/resource/findTransResourceOrderByXSIndex", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<FLTransResource> findTransResourceOrderByXSIndex(@RequestParam("ggId") String ggId);


    /**
     * 根据公告Id和状态获取顺序第一的地块
     *
     * @param ggId
     * @param status
     * @return
     */
    @RequestMapping(value = "/client/resource/getFirstTransResourceOrderByXSIndex", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    FLTransResource getFirstTransResourceOrderByXSIndex(@RequestParam("ggId") String ggId, @RequestParam("status") int status);

    /**
     * 更新地块状态
     * @param resource
     * @param status
     * @return
     */
    @RequestMapping(value = "/client/resource/saveTransResourceStatus", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<FLTransResource> saveTransResourceStatus(@RequestBody FLTransResource resource, @RequestParam(value = "status") int status);

    /**
     * 修改出让地块对象
     * @param resource 出让地块
     * @return
     */
    @RequestMapping(value = "/client/resource/updateTransResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<FLTransResource> updateTransResource(@RequestBody FLTransResource resource);


    /**
     * 获得正在交易的地块，成交和流拍的除外
     * @return
     */
    @RequestMapping(value = "/client/resource/getTransResourcesOnRelease", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<FLTransResource> getTransResourcesOnRelease();

    /**
     * 删除地块
     * @return
     */
    @RequestMapping(value = "/client/resource/deleteTransResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteTransResource(@RequestBody List<String> resourceIds);


    /**
     * 查询资源、分页，Admin用
     * @param title
     * @param status
     * @param pageable
     * @param ggId
     * @param regionCodes
     * @return
     */
    @RequestMapping(value = "/client/resource/findTransResourcesByEditStatus", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    Page<TransResource> findTransResourcesByEditStatus(@RequestParam(value = "title", required = false) String title, @RequestParam(value = "status", required = false) int status, @RequestParam(value = "ggId", required = false) String ggId, @RequestParam(value = "regionCodes", required = false) String regionCodes, @RequestBody Pageable pageable);

    /**
     * 移除
     * @param resourceId
     */
    @RequestMapping(value = "/client/resourceContainer/remove", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void remove(@RequestParam("resourceId") String resourceId);

    /**
     * 增加地块状态（竞配建）
     * @param
     */
    @RequestMapping(value = "/client/resourceContainer/addResourceStatus", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void addResourceStatus(@RequestParam("resourceId") String resourceId, @RequestParam("enterTime") long enterTime);

    /**
     * 增加地块状态（公租房）
     * @param
     */
    @RequestMapping(value = "/client/resourceContainer/addResourceStatusGzfOver", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void addResourceStatusGzfOver(@RequestParam("resourceId") String resourceId, @RequestParam("enterTime") long enterTime);


    /**
     * 修改监视器 地块状态为 最高限价
     * @param resourceId
     */
    @RequestMapping(value = "/client/resourceContainer/updateResourceMaxOffer", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void updateResourceMaxOffer(@RequestParam("resourceId") String resourceId);

    /**
     * 管理端修改地块状态为发布后 后 根据地块时间 修改resourceStatus
     *
     * @param resourceId
     */
    @RequestMapping(value = "/client/resourceContainer/checkResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void checkResource(@RequestParam("resourceId") String resourceId);

    /**
     * 获取申请人信息
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/client/resource-apply/getTransResourceApplyByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransResourceApply> getTransResourceApplyByResourceId(@RequestParam(value = "resourceId") String resourceId);

    /**
     * 获取
     * @param applyId
     * @return
     */
    @RequestMapping(value = "/client/resource-apply/getTransResourceApply", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransResourceApply getTransResourceApply(@RequestParam(value = "applyId",required = true) String applyId);

    /**
     * 保存
     * @param transResourceApply
     * @return
     */
    @RequestMapping(value = "/client/resource-apply/saveTransResourceApply", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransResourceApply> saveTransResourceApply(@RequestBody TransResourceApply transResourceApply);

    /**
     * 根据Id获取人员申请信息
     *
     * @param infoId
     * @return
     */
    @RequestMapping(value = "/client/userApplyInfo/getTransUserApplyInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransUserApplyInfo getTransUserApplyInfo(@RequestParam(value = "infoId") String infoId);

    /**
     * 根据用户id获取
     * @param userId
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/client/resource-apply/getTransResourceApplyByUserId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransResourceApply getTransResourceApplyByUserId(@RequestParam(value = "userId",required = true) String userId,@RequestParam(value = "resourceId",required = true) String resourceId);


    @RequestMapping(value = "/client/number/saveTransNumber", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransNumber> saveTransNumber(@RequestBody TransNumber transNumber);

    @RequestMapping(value = "/client/number/updataTransNumber", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransNumber> updataTransNumber(@RequestBody TransNumber transNumber);

    /**
     * 根据年份 类型 用途 查找当前号码
     * @param numberYear
     * @param numberType
     * @param numberYt
     * @return
     */
    @RequestMapping(value = "/client/number/getTransNumberByYearTypeYt", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransNumber getTransNumberByYearTypeYt(@RequestParam("numberYear") Integer numberYear, @RequestParam("numberType") Integer numberType, @RequestParam("numberYt") Integer numberYt);

    /**
     * 根据Id获取 联合竞买
     * @param unionId 联合竞买Id
     * @return 联合竞买对象
     */
    @RequestMapping(value = "/client/union/getTransUserUnion", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransUserUnion getTransUserUnion(@RequestParam(value = "unionId") String unionId);

    /**
     * 获取 联合竞买列表
     * @param applyId 地块申请Id
     * @return 出让公告对象
     */
    @RequestMapping(value = "/client/union/findTransUserUnion", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransUserUnion> findTransUserUnion(@RequestParam(value = "applyId") String applyId);

    /**
     * 保存联合竞买 信息
     * @param transUserUnion
     * @return
     */
    @RequestMapping(value = "/client/union/saveTransUserUnion", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransUserUnion> saveTransUserUnion(@RequestBody TransUserUnion transUserUnion);

    /**
     * 删除 联合竞买 对象
     * @param unionId 联合竞买Id
     * @return
     */
    @RequestMapping(value = "/client/union/deleteTransUserUnion", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteTransUserUnion(@RequestParam("unionId") String unionId);

    /**
     * 获取当前用户是被联合人的地块的联合竞买记录
     * @param userName 被联合人姓名，是姓名不是用户名
     * @param resourceId 地块Id
     * @return
     */
    @RequestMapping(value = "/client/union/getResourceTransUserUnionByUserName", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransUserUnion> getResourceTransUserUnionByUserName(@RequestParam(value = "userName", required = false) String userName, @RequestParam(value = "resourceId", required = false) String resourceId);
}
