package cn.gtmap.secondaryMarket.common.register;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 全文检索服务
 * @author zsj
 * @version v1.0, 2018/5/17
 */
@FeignClient(name = "search-server")
public interface ElasticSearchClient {

    /**
     * 批量保存
     * @param obs 保存列表
     * @param type 保存类型
     * @param mappings 索引类型 已存在可以不传
     */
    @RequestMapping(value = "/secondMarket/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void save(@RequestBody List<Object> obs, @RequestParam("type") String type, @RequestParam(value = "mappings", required = false) String mappings);

    /**
     * 查询
     * @param type 查询类型
     * @param condition 查询条件
     * @param pageable 分页
     * @return
     */
    @RequestMapping(value = "/secondMarket/search", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    Page<Object> search(@RequestParam("type") String type, @RequestParam("condition") String condition, Pageable pageable);

    /**
     * 分组查询
     * @param condition 查询条件
     * @param type 查询类型
     * @param field
     * @return
     */
    @RequestMapping(value = "/secondMarket/searchByFeature", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    Map searchByFeature(@RequestParam("condition") String condition, @RequestParam("type") String type, @RequestParam("field") String field);

    /**
     * 创建类型 与 Mapping
     * @param type
     * @param mappings
     */
    @RequestMapping(value = "/secondMarket/judgeIndexAndType", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    void judgeIndexAndType(@RequestParam("type") String type, @RequestParam("mappings") String mappings);

}
