package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransDiscredit;
import cn.gtmap.secondaryMarket.common.domain.vo.DiscreditFormVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 失信黑名单服务
 * @author zhangxingwei
 * @version 2018/8/9
 */
@FeignClient(name = "core-server")
public interface DiscreditClient {

    /**
     * 列表页查询
     * @param discreditFormVo
     * @return
     */
    @RequestMapping(value = "/transDiscredit/findTransDiscrecditPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransDiscredit> findTransDiscrecditPage(@RequestBody DiscreditFormVo discreditFormVo);

    /**
     * 添加操作 保存失信黑名单信息
     * @param transDiscredit
     * @return
     */
    @RequestMapping(value = "/transDiscredit/saveTransDiscrecdit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransDiscredit> saveTransDiscrecdit(@RequestBody TransDiscredit transDiscredit);

    /**
     * 更新操作 修改失信黑名单信息
     * @param transDiscredit
     * @return
     */
    @RequestMapping(value = "/transDiscredit/updateTransDiscrecdit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransDiscredit> updateTransDiscrecdit(@RequestBody TransDiscredit transDiscredit);

    /**
     * 根据主键删除
     * @param discreditId
     * @return
     */
    @RequestMapping(value = "/transDiscredit/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransDiscredit> deleteByPrimaryKey(@RequestParam(value = "discreditId") String discreditId);

    /**
     * 根据discreditId获取TransDiscredit对象
     * @param discreditId
     * @return
     */
    @RequestMapping(value = "/transDiscredit/getTransDiscredit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransDiscredit getTransDiscredit(@RequestParam (value = "discreditId") String discreditId);

    /**
     * 根据discreditIds数组来删除
     * @param discreditIds
     * @return
     */
    @RequestMapping(value = "/transDiscredit/deleteBydiscreditIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteBydiscreditIds(@RequestParam (value = "discreditIds") String[] discreditIds);
}
