package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ContractTemplate;
import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.form.ContractTemplateForm;
import cn.gtmap.secondaryMarket.common.domain.vo.ContractTemplateVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * 合同模板服务
 * @author: zhujunjie
 * @date: 2019/6/5
 **/
@FeignClient(name = "core-server")
public interface ContractTemplateClient {

    /**
     * 保存或者修改
     * @param contractTemplate
     * @return
     */
    @RequestMapping(value = "/contractTemplate/saveOrUpdate", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<ContractTemplate> saveOrUpdate(@RequestBody ContractTemplate contractTemplate);

    /**
     * 根据主键查询
     * @param templateId
     * @return
     */
    @RequestMapping(value = "/contractTemplate/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ContractTemplate selectByPrimaryKey(@RequestParam(value="templateId") String templateId);

    /**
     * 根据类型查询
     * @param templateType
     * @return
     */
    @RequestMapping(value = "/contractTemplate/getByTemplateType", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ContractTemplate getByTemplateType(@RequestParam(value="templateType") Integer templateType,
                                       @RequestParam(value="contractType", required = false) String contractType,
                                       @RequestParam(value="sort", required = false) Integer sort);

    /**
     * 分页查询
     * @param form
     * @return
     */
    @RequestMapping(value = "/contractTemplate/findTemplePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<ContractTemplateVo> findTemplePage(@RequestBody ContractTemplateForm form);


    /**
     * 根据id批量删除
     * @param templateIds
     * @return
     */
    @RequestMapping(value = "/contractTemplate/deleteByTemplateIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByTemplateIds(@RequestParam(value="templateIds") String[] templateIds);
}
