package cn.gtmap.secondaryMarket.common.domain.vo;

import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 参数实体类
 * @author zhujunjie
 */
public class FormVo implements Serializable {

    /**
     * 用户id
     */
    public String userId;

    /**
     * 标题
     */
    private String publishTitle;

    /**
     * 县区
     */
    private String countyCode;

    /**
     * 街道
     */
    private String streetCode;

    /**
     * 土地用途
     */
    private String tdyt;

    /**
     * 交易状态
     */
    private Integer dealStatus;

    /**
     * 发布状态
     */
    private Integer publishStatus;

    /**
     * 内外网：0表示内网，1表示外网
     */
    private Integer netType;

    /**
     * 会员创建的地块的审核状态
     */
    private Integer displayStatus;
    
    /**
     * 合同审核状态
     */
    private Integer contractStatus;

    /**
     * 默认排序
     */
    private String mrFlag;

    /**
     * 面积排序
     */
    private String mjFlag;

    /**
     * 年限排序
     */
    private String jeFlag;

    /**
     * 是否导出
     */
    private Integer exportStatus;

    /**
     * 是否推介
     */
    private Integer isIntroduction;

    /**
     * 0是转让、1是出租、2是抵押
     * 土地需求流转类型：3求租4求购
     */
    private Integer publishLandType;

    /**
     * 如果是转让：0是划拨 1是出让 2是分割转让 3是更名 4是合并 5是分立
     * 如果是出租：0是划拨 1是出让
     * 如果是抵押：0是变更 1是首次登记 2是注销 3是转移
     */
    private String jyLx;

    /**
     * 权利人
     */
    private String holderName;

    /**
     * 土地使用权性质
     */
    private String landUseRight;

    /**
     * 分页信息
     */
    private PageRequest page;

    private String nxFlag;

    private String extraSign;//特殊的字段，用于sql条件判断
    
    private BigDecimal minArea; //最小面积
    private BigDecimal maxArea; //最大面积
    private BigDecimal minPrice; //最小价格
    private BigDecimal maxPrice; //最大价格
    private BigDecimal minQwPrice; //期望最小价格
    private BigDecimal maxQwPrice; //期望最大价格
    
    private String landTypeBig;//土地用途大类

    private Integer organizationType;

    private String organizationName;

    private String sfsh;
    private String mapImgFileId;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPublishTitle() {
        return publishTitle;
    }

    public void setPublishTitle(String publishTitle) {
        this.publishTitle = publishTitle;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getLandUseRight() {
        return landUseRight;
    }

    public void setLandUseRight(String landUseRight) {
        this.landUseRight = landUseRight;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public Integer getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(Integer dealStatus) {
        this.dealStatus = dealStatus;
    }

    public Integer getPublishStatus() {
        return publishStatus;
    }

    public void setPublishStatus(Integer publishStatus) {
        this.publishStatus = publishStatus;
    }

    public Integer getNetType() {
        return netType;
    }

    public void setNetType(Integer netType) {
        this.netType = netType;
    }

    public Integer getDisplayStatus() {
        return displayStatus;
    }

    public void setDisplayStatus(Integer displayStatus) {
        this.displayStatus = displayStatus;
    }

    public String getMrFlag() {
        return mrFlag;
    }

    public void setMrFlag(String mrFlag) {
        this.mrFlag = mrFlag;
    }

    public String getMjFlag() {
        return mjFlag;
    }

    public void setMjFlag(String mjFlag) {
        this.mjFlag = mjFlag;
    }

    public String getJeFlag() {
        return jeFlag;
    }

    public void setJeFlag(String jeFlag) {
        this.jeFlag = jeFlag;
    }

    public Integer getExportStatus() {
        return exportStatus;
    }

    public void setExportStatus(Integer exportStatus) {
        this.exportStatus = exportStatus;
    }

    public Integer getIsIntroduction() {
        return isIntroduction;
    }

    public void setIsIntroduction(Integer isIntroduction) {
        this.isIntroduction = isIntroduction;
    }

    public Integer getPublishLandType() {
        return publishLandType;
    }

    public void setPublishLandType(Integer publishLandType) {
        this.publishLandType = publishLandType;
    }

    public String getJyLx() {
        return jyLx;
    }

    public void setJyLx(String jyLx) {
        this.jyLx = jyLx;
    }

    public String getHolderName() {
        return holderName;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public PageRequest getPage() {
        return page;
    }

    public void setPage(PageRequest page) {
        this.page = page;
    }

    public String getNxFlag() {
        return nxFlag;
    }

    public void setNxFlag(String nxFlag) {
        this.nxFlag = nxFlag;
    }

	/**
	 * @return the contractStatus
	 */
	public Integer getContractStatus() {
		return contractStatus;
	}

	/**
	 * @param contractStatus the contractStatus to set
	 */
	public void setContractStatus(Integer contractStatus) {
		this.contractStatus = contractStatus;
	}

    public String getExtraSign() {
        return extraSign;
    }

    public void setExtraSign(String extraSign) {
        this.extraSign = extraSign;
    }

	/**
	 * @return the minArea
	 */
	public BigDecimal getMinArea() {
		return minArea;
	}

	/**
	 * @param minArea the minArea to set
	 */
	public void setMinArea(BigDecimal minArea) {
		this.minArea = minArea;
	}

	/**
	 * @return the maxArea
	 */
	public BigDecimal getMaxArea() {
		return maxArea;
	}

	/**
	 * @param maxArea the maxArea to set
	 */
	public void setMaxArea(BigDecimal maxArea) {
		this.maxArea = maxArea;
	}

	/**
	 * @return the minPrice
	 */
	public BigDecimal getMinPrice() {
		return minPrice;
	}

	/**
	 * @param minPrice the minPrice to set
	 */
	public void setMinPrice(BigDecimal minPrice) {
		this.minPrice = minPrice;
	}

	/**
	 * @return the maxPrice
	 */
	public BigDecimal getMaxPrice() {
		return maxPrice;
	}

	/**
	 * @param maxPrice the maxPrice to set
	 */
	public void setMaxPrice(BigDecimal maxPrice) {
		this.maxPrice = maxPrice;
	}

	/**
	 * @return the minQwPrice
	 */
	public BigDecimal getMinQwPrice() {
		return minQwPrice;
	}

	/**
	 * @param minQwPrice the minQwPrice to set
	 */
	public void setMinQwPrice(BigDecimal minQwPrice) {
		this.minQwPrice = minQwPrice;
	}

	/**
	 * @return the maxQwPrice
	 */
	public BigDecimal getMaxQwPrice() {
		return maxQwPrice;
	}

	/**
	 * @param maxQwPrice the maxQwPrice to set
	 */
	public void setMaxQwPrice(BigDecimal maxQwPrice) {
		this.maxQwPrice = maxQwPrice;
	}

	/**
	 * @return the landTypeBig
	 */
	public String getLandTypeBig() {
		return landTypeBig;
	}

	/**
	 * @param landTypeBig the landTypeBig to set
	 */
	public void setLandTypeBig(String landTypeBig) {
		this.landTypeBig = landTypeBig;
	}

    public Integer getOrganizationType() {
        return organizationType;
    }

    public void setOrganizationType(Integer organizationType) {
        this.organizationType = organizationType;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getSfsh() {
        return sfsh;
    }

    public void setSfsh(String sfsh) {
        this.sfsh = sfsh;
    }

	public String getMapImgFileId() {
		return mapImgFileId;
	}

	public void setMapImgFileId(String mapImgFileId) {
		this.mapImgFileId = mapImgFileId;
	}
}
