package cn.gtmap.secondaryMarket.common.domain.firstmarket;


import cn.gtmap.egovplat.core.support.hibernate.UUIDHexGenerator;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 公告 地块自动编号表
 * @author zsj
 * @version v1.0, 2017/9/6
 */
@Entity
@Table(name = "trans_number")
/*@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)*/
public class TransNumber implements Serializable {

    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = UUIDHexGenerator.TYPE)
    @Column(length = 32)
    private String numberId;

    @Column
    private Integer numberYear;

    @Column
    private Integer numberType;

    @Column
    private Integer numberYt;

    @Column
    private Integer numberCurrent;

    @Column
    private Integer numberLastMax;

    public TransNumber() {
    }

    public TransNumber(Integer numberYear, Integer numberType, Integer numberYt, Integer numberCurrent, Integer numberLastMax) {
        this.numberYear = numberYear;
        this.numberType = numberType;
        this.numberYt = numberYt;
        this.numberCurrent = numberCurrent;
        this.numberLastMax = numberLastMax;
    }

    public String getNumberId() {
        return numberId;
    }

    public void setNumberId(String numberId) {
        this.numberId = numberId;
    }

    public Integer getNumberYear() {
        return numberYear;
    }

    public void setNumberYear(Integer numberYear) {
        this.numberYear = numberYear;
    }

    public Integer getNumberType() {
        return numberType;
    }

    public void setNumberType(Integer numberType) {
        this.numberType = numberType;
    }

    public Integer getNumberYt() {
        return numberYt;
    }

    public void setNumberYt(Integer numberYt) {
        this.numberYt = numberYt;
    }

    public Integer getNumberCurrent() {
        return numberCurrent;
    }

    public void setNumberCurrent(Integer numberCurrent) {
        this.numberCurrent = numberCurrent;
    }

    public Integer getNumberLastMax() {
        return numberLastMax;
    }

    public void setNumberLastMax(Integer numberLastMax) {
        this.numberLastMax = numberLastMax;
    }
}
