package cn.gtmap.secondaryMarket.common.domain.firstmarket;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.support.hibernate.UUIDHexGenerator;
import cn.gtmap.secondaryMarket.common.format.DateDeserializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 网上交易出让公告实体对象
 * @author jiff on 14/12/24.
 */
@Entity
@Table(name = "trans_crgg")
public class TransCrgg implements Serializable {
//    private static final long serialVersionUID = -9137292468621763148L;
    @Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = UUIDHexGenerator.TYPE)
    @Column(length = 32)
    private String ggId;

    /**
     * 公告标题
     */
    @Column(nullable = false,length = 255)
    private String ggTitle;


    /**
     * 公告开始时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date ggBeginTime;

    /**
     * 公告结束时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date ggEndTime;

    /**
     * 公告内容
     */
    @Column (nullable = true,columnDefinition ="CLOB")
    private String ggContent;

    /**
     * 公告编号
     */
    @Column (nullable = true,columnDefinition ="CLOB")
    private String ggNum;

    @Column(columnDefinition = "number(1) default '0'")
    @Field(value = "0-未发布 1-发布")
    private int crggStatus;

    public String getGgId() {
        return ggId;
    }

    public void setGgId(String ggId) {
        this.ggId = ggId;
    }

    public String getGgTitle() {
        return ggTitle;
    }

    public void setGgTitle(String ggTitle) {
        this.ggTitle = ggTitle;
    }

    public Date getGgBeginTime() {
        return ggBeginTime;
    }

    public void setGgBeginTime(Date ggBeginTime) {
        this.ggBeginTime = ggBeginTime;
    }

    public Date getGgEndTime() {
        return ggEndTime;
    }

    public void setGgEndTime(Date ggEndTime) {
        this.ggEndTime = ggEndTime;
    }

    public String getGgContent() {
        return ggContent;
    }

    public void setGgContent(String ggContent) {
        this.ggContent = ggContent;
    }

    public String getGgNum() {
        return ggNum;
    }

    public void setGgNum(String ggNum) {
        this.ggNum = ggNum;
    }

    public int getCrggStatus() {
        return crggStatus;
    }

    public void setCrggStatus(int crggStatus) {
        this.crggStatus = crggStatus;
    }
}
