package cn.gtmap.secondaryMarket.common.domain.firstmarket;


import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.secondaryMarket.common.constants.FLConstants;
import cn.gtmap.secondaryMarket.common.format.DateDeserializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 网上交易出让地块实体对象
 * @author jiff on 14/12/14.
 */
@Entity
@Table(name = "first_level_trans_resource")
public class FLTransResource implements Serializable {
    @Id
    @Column(length = 32)
    private String resourceId;

    @Column(length = 32)
    private String ggId;

    /**
     * 成交公告id
     */
    @Column(length = 32)
    private String dealNoticeId;

    /**
     * 关联供应信息id
     */
    @Column(length = 32)
    private String relationId;

    /**
     * 成交公告id
     */
    @Column(length = 32)
    private String suspendNoticeId;

    /**
     * 地块编号
     */
    @Column(length = 50)
    private String resourceCode;

    /**
     * 地块名称
     */
    @Column(length = 50)
    private String resourceName;

    @Column(nullable = false)
    private String resourceLocation;

    /**
     * 所属行政区
     */
    @Column(length = 32)
    private String regionCode;

    /**
     * 所属组织
     */
    @Column(length = 50)
    private String organizeId;

    /**
     * 资格审核
     */
    @Column(length = 50)
    private String qualificationType;

    /**
     * 资源编辑状态
     */
    @Column(nullable = false,columnDefinition ="number(2) default '0'")
    private Integer resourceEditStatus=0;

    @Column(nullable = false,columnDefinition ="number(2) default '0'")
    private Integer resourceStatus;

    /**
     * 资源类别
     */
    @Column(columnDefinition ="number(2) default '0'")
    private int resourceType;

    /**
     * 报名开始时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date bmBeginTime;

    /**
     * 报名截至时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date bmEndTime;

    /**
     * 挂牌开始时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date gpBeginTime;

    /**
     * 挂牌截至时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date gpEndTime;

    /**
     * 限时竞价开始时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date xsBeginTime;

    /**
     * 保证金开始时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date bzjBeginTime;

    /**
     * 保证金截至时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date bzjEndTime;

    /**
     * 出让面积
     */
    @Column(nullable = false,precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
    private Double crArea;

    /**
     * 建筑面积 报价单位为 楼面价时必填
     */
    @Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
    private Double buildingArea;

    /**
     * 起始价(万元)
     */
    @Column(nullable = false,precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
    private Double beginOffer;

    /**
     * 是否资格前审
     */
    @Column(nullable = false,columnDefinition ="number(1,1) default '0'")
    private Integer beforeBzjAudit;

    /**
     * 保证金(万元)
     */
    @Column(nullable = false,precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
    private Double fixedOffer;

    /**
     * 保证金美元(美元)
     */
    @Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
    private Double fixedOfferUsd;

    /**
     * 保证金美元(美元)
     */
    @Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
    private Double fixedOfferHkd;

    /**
     * 竞价增价幅度(万元)
     */
    @Column(nullable = false,precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
    private Double addOffer;

    /**
     * 是否有最高限价
     */
    @Column
    private Integer maxOfferExist;

    /**
     * 最高限价
     */
    @Column(precision = 18,scale =6,columnDefinition ="number(18,6)")
    private Double maxOffer;

    /**
     * 最高限价后的 选择的成交方式
     */
    @Column(precision = 2)
    private FLConstants.MaxOfferChoose maxOfferChoose;

    /**
     * 该地块最后的 成交方式
     */
    @Column(precision = 2)
    private Integer successOfferChoose;

    /**
     * 是否有底价 0否 1是
     */
    @Column
    private Integer minOffer;

    /**
     * 报价单位，0-万元（总价） 1-元/平方米 2-万元/亩
     */
    @Column(nullable = false,columnDefinition ="number(1) default '0'")
    private int offerUnit;

    /**
     * 规划用途
     */
    @Column(precision = 2)
    private FLConstants.LandUse landUse;

    /**
     * 新的规划用途
     */
    @Column(length = 50)
    private String tdytCode; //实际为建设用途

    /**
     * 新的规划用途名称
     */
    @Column(length = 50)
    private String tdytName; //实际为建设用途

    /**
     * 保证金缴纳银行
     */
    @Column(length = 100)
    private String banks;

    /**
     * 结束时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date overTime;

    /**
     * 成交信息
     */
    @Column
    private String offerId;

    /**
     * 地块坐标Geojson格式
     */
    @Column(nullable = true,columnDefinition ="CLOB")
    private String geometry;

    /**
     * 资源是否显示在大屏幕上
     */
    @Column(nullable = true,columnDefinition ="number(1) default '0'")
    private int displayStatus=0;

    /**
     * 出让单位
     */
    @Column(length = 200)
    private String ownershipUnit;

    /**
     * 交易方式
     */
    @Column(length = 20)
    private FLConstants.OfferType offerType= FLConstants.OfferType.LISTING;

    /**
     * 竞价规则
     */
    @Column(nullable = true,columnDefinition ="number(1) default '0'")
    private FLConstants.BidRule bidRule= FLConstants.BidRule.JGZD;

    /**
     * 出价方式
     */
    @Column(nullable = true,columnDefinition ="number(1) default '0'")
    private FLConstants.BidType bidType= FLConstants.BidType.ZJ_WANYUAN;

    /**
     * 成交审核Id
     */
    @Column(length = 32)
    @Field("成交审核Id")
    private String resourceVerifyId;


    //==============================苏州园区地块字段调整
    @Column(length = 20)
    @Field("供地方式-00-出让")
    private String dealType;


    /**
     * 地块交易统计
     */
    @Transient
    private int unVerif=0;//未审核//未审核
    @Transient
    private int passed=0;//已通过
    @Transient
    private int unpass=0;//未通过

    @Transient
    private List<TransFile> attachmentList;

    @Column(columnDefinition ="number(2) default '0'")
    private Integer xsIndex = 0; //多地块限时竞价次序

    @Column(columnDefinition ="number(2) default '0'")
    private Integer xsWaitStatus = 0; //多地块限时竞价等待状态  0等待 1进入限时

    /**
     * 估价报告备案编号
     */
    @Column(length = 50)
    private String gjbgCode;

    @Column(length = 32)
    private String createUserId;

    /**
     * 分割销售比例
     */
    @Column(length = 200)
    private String fgxsRate;

    @Transient
    private TransResourceInfo transResourceInfo;

    @Transient
    private TransResourceSon transResourceSon;

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getDealNoticeId() {
        return dealNoticeId;
    }

    public void setDealNoticeId(String dealNoticeId) {
        this.dealNoticeId = dealNoticeId;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public String getSuspendNoticeId() {
        return suspendNoticeId;
    }

    public void setSuspendNoticeId(String suspendNoticeId) {
        this.suspendNoticeId = suspendNoticeId;
    }

    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public String getResourceLocation() {
        return resourceLocation;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public Integer getResourceEditStatus() {
        return resourceEditStatus;
    }

    public void setResourceEditStatus(Integer resourceEditStatus) {
        this.resourceEditStatus = resourceEditStatus;
    }

    public Integer getResourceStatus() {
        return resourceStatus;
    }

    public void setResourceStatus(Integer resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getOrganizeId() {
        return organizeId;
    }

    public void setOrganizeId(String organizeId) {
        this.organizeId = organizeId;
    }

    public int getResourceType() {
        return resourceType;
    }

    public void setResourceType(int resourceType) {
        this.resourceType = resourceType;
    }

    public Date getBmBeginTime() {
        return bmBeginTime;
    }

    public void setBmBeginTime(Date bmBeginTime) {
        this.bmBeginTime = bmBeginTime;
    }

    public Date getBmEndTime() {
        return bmEndTime;
    }

    public void setBmEndTime(Date bmEndTime) {
        this.bmEndTime = bmEndTime;
    }

    public Date getGpBeginTime() {
        return gpBeginTime;
    }

    public void setGpBeginTime(Date gpBeginTime) {
        this.gpBeginTime = gpBeginTime;
    }

    public Date getGpEndTime() {
        return gpEndTime;
    }

    public void setGpEndTime(Date gpEndTime) {
        this.gpEndTime = gpEndTime;
    }

    public Date getXsBeginTime() {
        return xsBeginTime;
    }

    public void setXsBeginTime(Date xsBeginTime) {
        this.xsBeginTime = xsBeginTime;
    }

    public Date getBzjEndTime() {
        return bzjEndTime;
    }

    public void setBzjEndTime(Date bzjEndTime) {
        this.bzjEndTime = bzjEndTime;
    }

    public Double getCrArea() {
        return crArea;
    }

    public void setCrArea(Double crArea) {
        this.crArea = crArea;
    }

    public Double getBuildingArea() {
        return buildingArea;
    }

    public void setBuildingArea(Double buildingArea) {
        this.buildingArea = buildingArea;
    }

    public Double getBeginOffer() {
        return beginOffer;
    }

    public void setBeginOffer(Double beginOffer) {
        this.beginOffer = beginOffer;
    }

    public Double getFixedOffer() {
        return fixedOffer;
    }

    public void setFixedOffer(Double fixedOffer) {
        this.fixedOffer = fixedOffer;
    }

    public Double getAddOffer() {
        return addOffer;
    }

    public void setAddOffer(Double addOffer) {
        this.addOffer = addOffer;
    }

    public String getOfferId() {
        return offerId;
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public void setOfferId(String offerId) {
        this.offerId = offerId;
    }

    public String getGgId() {
        return ggId;
    }

    public void setGgId(String ggId) {
        this.ggId = ggId;
    }

    public String getBanks() {
        return banks;
    }

    public Integer getBeforeBzjAudit() {
        return beforeBzjAudit;
    }

    public void setBeforeBzjAudit(Integer beforeBzjAudit) {
        this.beforeBzjAudit = beforeBzjAudit;
    }

    public void setBanks(String banks) {
        this.banks = banks;
    }

    public Date getBzjBeginTime() {
        return bzjBeginTime;
    }

    public void setBzjBeginTime(Date bzjBeginTime) {
        this.bzjBeginTime = bzjBeginTime;
    }

    public String getGeometry() {
        return geometry;
    }

    public void setGeometry(String geometry) {
        this.geometry = geometry;
    }

    public List<TransFile> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<TransFile> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public Date getOverTime() {
        return overTime;
    }

    public void setOverTime(Date overTime) {
        this.overTime = overTime;
    }

    public Integer getMaxOfferExist() {
        return maxOfferExist;
    }

    public void setMaxOfferExist(Integer maxOfferExist) {
        this.maxOfferExist = maxOfferExist;
    }

    public Double getMaxOffer() {
        return maxOffer;
    }

    public void setMaxOffer(Double maxOffer) {
        this.maxOffer = maxOffer;
    }

    public FLConstants.MaxOfferChoose getMaxOfferChoose() {
        return maxOfferChoose;
    }

    public void setMaxOfferChoose(FLConstants.MaxOfferChoose maxOfferChoose) {
        this.maxOfferChoose = maxOfferChoose;
    }

    public Integer getSuccessOfferChoose() {
        return successOfferChoose;
    }

    public void setSuccessOfferChoose(Integer successOfferChoose) {
        this.successOfferChoose = successOfferChoose;
    }

    public FLConstants.LandUse getLandUse() {
        return landUse;
    }

    public void setLandUse(FLConstants.LandUse landUse) {
        this.landUse = landUse;
    }

    public String getTdytCode() {
        return tdytCode;
    }

    public void setTdytCode(String tdytCode) {
        this.tdytCode = tdytCode;
    }

    public String getTdytName() {
        return tdytName;
    }

    public void setTdytName(String tdytName) {
        this.tdytName = tdytName;
    }

    public Integer getMinOffer() {
        return minOffer;
    }

    public void setMinOffer(Integer minOffer) {
        this.minOffer = minOffer;
    }

    public int getOfferUnit() {
        return offerUnit;
    }

    public void setOfferUnit(int offerUnit) {
        this.offerUnit = offerUnit;
    }

    public int getDisplayStatus() {
        return displayStatus;
    }

    public String getDealType() {
        return dealType;
    }

    public void setDealType(String dealType) {
        this.dealType = dealType;
    }

    public void setDisplayStatus(int displayStatus) {
        this.displayStatus = displayStatus;
    }


    public String getOwnershipUnit() {
        return ownershipUnit;
    }

    public void setOwnershipUnit(String ownershipUnit) {
        this.ownershipUnit = ownershipUnit;
    }

    public FLConstants.OfferType getOfferType() {
        return offerType;
    }

    public void setOfferType(FLConstants.OfferType offerType) {
        this.offerType = offerType;
    }

    public FLConstants.BidRule getBidRule() {
        return bidRule;
    }

    public void setBidRule(FLConstants.BidRule bidRule) {
        this.bidRule = bidRule;
    }

    public FLConstants.BidType getBidType() {
        return bidType;
    }

    public void setBidType(FLConstants.BidType bidType) {
        this.bidType = bidType;
    }

    public Double getFixedOfferUsd() {
        return fixedOfferUsd;
    }

    public void setFixedOfferUsd(Double fixedOfferUsd) {
        this.fixedOfferUsd = fixedOfferUsd;
    }

    public Double getFixedOfferHkd() {
        return fixedOfferHkd;
    }

    public void setFixedOfferHkd(Double fixedOfferHkd) {
        this.fixedOfferHkd = fixedOfferHkd;
    }

    public TransResourceInfo getTransResourceInfo() {
        return transResourceInfo;
    }

    public void setTransResourceInfo(TransResourceInfo transResourceInfo) {
        this.transResourceInfo = transResourceInfo;
    }

    public String getResourceVerifyId() {
        return resourceVerifyId;
    }

    public void setResourceVerifyId(String resourceVerifyId) {
        this.resourceVerifyId = resourceVerifyId;
    }

    public int getUnVerif() {
        return unVerif;
    }

    public void setUnVerif(int unVerif) {
        this.unVerif = unVerif;
    }

    public int getPassed() {
        return passed;
    }

    public void setPassed(int passed) {
        this.passed = passed;
    }

    public int getUnpass() {
        return unpass;
    }

    public void setUnpass(int unpass) {
        this.unpass = unpass;
    }

    public Integer getXsIndex() {
        return xsIndex;
    }

    public void setXsIndex(Integer xsIndex) {
        this.xsIndex = xsIndex;
    }

    public Integer getXsWaitStatus() {
        return xsWaitStatus;
    }

    public void setXsWaitStatus(Integer xsWaitStatus) {
        this.xsWaitStatus = xsWaitStatus;
    }

    public String getGjbgCode() {
        return gjbgCode;
    }

    public void setGjbgCode(String gjbgCode) {
        this.gjbgCode = gjbgCode;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public TransResourceSon getTransResourceSon() {
        return transResourceSon;
    }

    public void setTransResourceSon(TransResourceSon transResourceSon) {
        this.transResourceSon = transResourceSon;
    }

    public String getFgxsRate() {
        return fgxsRate;
    }

    public void setFgxsRate(String fgxsRate) {
        this.fgxsRate = fgxsRate;
    }

    public String getQualificationType() {
        return qualificationType;
    }

    public void setQualificationType(String qualificationType) {
        this.qualificationType = qualificationType;
    }
}
