/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: File.java
 *
 * LastModified: 2009-09-23 04:34:19
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package cn.gtmap.secondaryMarket.common.domain.fileCenter;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-15
 */
public class File extends NodeImpl {

    private static final long serialVersionUID = -6793818023415798768L;

    public static final String[] IMAGE_POSTFIX = {"gif", "bmp", "jpg", "jpeg", "png"};
    public static final String[] DOCUMENT_POSTFIX = {"doc", "docx", "xls", "xlsx", "ppt", "pptx", "pdf", "ceb"};

    private long size;
    private String storeUrl;
    private StoreUrl su;
    private String ext;

    @Override
    public void setName(String name) {
        ext = null;
        super.setName(name);
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getStoreUrl() {
        return storeUrl;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeUrl = storeUrl;
        su = null;
    }

    public StoreUrl getStoreUrlObject() {
        if (su == null) {
        }
        su = new StoreUrl(storeUrl);
        return su;
    }

    public String getExtension() {
        if (ext == null) {
            int index = getName().lastIndexOf('.');
            ext = index > -1 ? getName().substring(index + 1).toLowerCase() : "";
        }
        return ext;
    }

    public boolean isImage() {
        String postfix = getExtension();
        for (String s : IMAGE_POSTFIX)
            if (s.equals(postfix))
                return true;
        return false;
    }

    public boolean isDocument() {
        String postfix = getExtension();
        for (String s : DOCUMENT_POSTFIX)
            if (s.equals(postfix))
                return true;
        return false;
    }

    @Override
    public int getType() {
        return Node.TYPE_FILE;
    }

    @Override
    public void setType(int type) {
    }

    @Override
    public Integer getChildCount() {
        return 0;
    }
}
