package cn.gtmap.secondaryMarket.common.domain;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.support.hibernate.UUIDHexGenerator;
import cn.gtmap.secondaryMarket.common.format.DateDeserializer;

/**
 * 用户实体类
 * @author zsj
 * @version v1.0, 2018/5/12
 */
@Entity
@Table(name = "trans_user")
public class TransUser implements Serializable{
	private static final long serialVersionUID = 1L;
	@Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = UUIDHexGenerator.TYPE)
    @Column(length = 32)
    private String userId;
    
	@Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
    @Field(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date createAt;

	@Column(length = 2000)
    @Field(value = "描述")
    private String description;

	@Column(precision = 2)
    @Field("性别")
    private String gender;

	@Column(length = 16)
	@Field(value = "手机号")
    private String mobile;

	@Column(length = 100)
    @Field("密码")
    private String password;

	@Column(length = 2000)
    @Field(value = "用户所具有的权限")
    private String privilege;

	@Column(precision = 1)
    @Field(value = "状态")
    private Short status;

	@Column(precision = 1, nullable = false)
    @Field(value = "用户类型")
    private Short type;

	@Column(precision = 20)
    @Field("编号")
    private String userCode;

    @Column(length = 200, nullable = false,unique = true)
    @Field("用户名")
    private String userName;

    @Column(length = 200)
    @Field("显示名")
    private String viewName;

    /**
     * 证件号唯一
     */
    @Column(length = 200)
    @Field("证件号")
    private String certificateId;

    @Column(length = 20)
    @Field("行政区代码")
    private String regionCode;
    
    @Column(length = 20)
    @Field("地址")
    private String address;
    
    @Column(length = 200)
    @Field("CA名称")
    private String caName;

    @Column(length = 50,unique = true)
    @Field(value = "CA数字证书指纹")
    private String caThumbprint;

    @Column(columnDefinition = "CLOB")
    @Field(value = "CA数字证书内容")
    private String caCertificate;

    @Temporal(TemporalType.TIMESTAMP)
    @Field(value = "CA证书启用时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date caNotBeforeTime;

    @Temporal(TemporalType.TIMESTAMP)
    @Field(value = "CA证书失效时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date caNotAfterTime;
    
    @Transient
    private String organizeName;

    public TransUser(String userId, Date createAt, String description, String gender, String mobile, String password, String privilege, Short status, Short type, String userCode, String userName, String viewName, String certificateId, String address, String regionCode, String caName, String caThumbprint, String caCertificate, Date caNotBeforeTime, Date caNotAfterTime) {
        this.userId = userId;
        this.createAt = createAt;
        this.description = description;
        this.gender = gender;
        this.mobile = mobile;
        this.password = password;
        this.privilege = privilege;
        this.status = status;
        this.type = type;
        this.userCode = userCode;
        this.userName = userName;
        this.viewName = viewName;
        this.certificateId = certificateId;
        this.address = address;
        this.regionCode = regionCode;
        this.caName = caName;
        this.caThumbprint = caThumbprint;
        this.caCertificate = caCertificate;
        this.caNotBeforeTime = caNotBeforeTime;
        this.caNotAfterTime = caNotAfterTime;
    }

    public TransUser() {
        super();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? null : userId.trim();
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender == null ? null : gender.trim();
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile == null ? null : mobile.trim();
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password == null ? null : password.trim();
    }

    public String getPrivilege() {
        return privilege;
    }

    public void setPrivilege(String privilege) {
        this.privilege = privilege == null ? null : privilege.trim();
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode == null ? null : userCode.trim();
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getViewName() {
        return viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName == null ? null : viewName.trim();
    }

    public String getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(String certificateId) {
        this.certificateId = certificateId == null ? null : certificateId.trim();
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode == null ? null : regionCode.trim();
    }

	/**
	 * @return the caName
	 */
	public String getCaName() {
		return caName;
	}

	/**
	 * @param caName the caName to set
	 */
	public void setCaName(String caName) {
		this.caName = caName;
	}

	public String getCaThumbprint() {
		return caThumbprint;
	}

	public void setCaThumbprint(String caThumbprint) {
		this.caThumbprint = caThumbprint;
	}

	public String getCaCertificate() {
		return caCertificate;
	}

	public void setCaCertificate(String caCertificate) {
		this.caCertificate = caCertificate;
	}

	public Date getCaNotBeforeTime() {
		return caNotBeforeTime;
	}

	public void setCaNotBeforeTime(Date caNotBeforeTime) {
		this.caNotBeforeTime = caNotBeforeTime;
	}

	public Date getCaNotAfterTime() {
		return caNotAfterTime;
	}

	public void setCaNotAfterTime(Date caNotAfterTime) {
		this.caNotAfterTime = caNotAfterTime;
	}

	public String getOrganizeName() {
		return organizeName;
	}

	public void setOrganizeName(String organizeName) {
		this.organizeName = organizeName;
	}
}