package cn.gtmap.secondaryMarket.common.domain;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

@Entity
@Table(name = "trans_resource")
public class TransResource {
	@Id
	@Column(length = 32)
	private String resourceId;

	@Column(length = 4000)
	private String publishTitle;

	@Column
	private Integer publishLandType;

	@Column(length = 64)
	private String provinceCode;
	@Column(length = 64)
	private String cityCode;
	@Column(length = 64)
	private String countyCode;
	@Column(length = 64)
	private String streetCode;
	@Column(length = 4000)
	private String holderName;
	@Column(length = 32)
	private String publishUserId;
	@Column(length = 32)
	private String ggId;
	@Temporal(TemporalType.TIMESTAMP)
	private Date createAt;

	@Temporal(TemporalType.TIMESTAMP)
	private Date updateDate;

	@Temporal(TemporalType.TIMESTAMP)
	private Date publishDate;

	@Temporal(TemporalType.TIMESTAMP)
	private Date transactionDate;
	@Column(length = 32)
	private String createUser;

	@Column
	private Integer publishStatus;

	@Column
	private Integer dealStatus;
	@Column(length = 4000)
	private String coverinfo;

	@Column
	private Integer isIntroduction;

	@Column
	private Integer netType;
	@Column(length = 128)
	private String jyLx;

	@Column
	private Integer displayStatus;
	@Column(length = 150)
	private String processinstanceId;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
	private BigDecimal tdZmj;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
	private BigDecimal jyZmj;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
	private BigDecimal jyZje;
	@Column(length = 4000)
	private String linkMan;
	@Column(length = 32)
	private String linkPhone;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
	private BigDecimal qwPrice;
	@Column (columnDefinition ="CLOB")
	private String landCoordinate;

	@Column
	private Integer underLineFlag;
	@Column(length = 64)
	private String landUseRight;

	@Column
	private Integer assessment;

	@Column
	private Integer assessmentType;
	@Column(length = 1000)
	private String remarkReason;
	@Column(length = 50)
	private String landType;//交易物类型（接口新增）

	@Temporal(TemporalType.TIMESTAMP)
	private Date endDate;//终止日期（接口新增）

	@Column
	private Integer years;//剩余年限（接口新增）
	@Column(length = 400)
	private String decisionNum;//划拨/出让决定书号（接口新增）
	@Column(length = 32)
	private String adjunct;//是否有附属物(0:是；1：否）（接口新增）

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
	private BigDecimal buildArea;//建筑面积（接口新增）
	@Column(length = 50)
	private String buildingStructure;//建筑结构（接口新增）
	@Column(length = 3000)
	private String ownerShipNature;//权属人性质（接口新增）
	@Column(length = 100)
	private String ownerAddress;//权属人联系地址（接口新增）
	@Column(length = 1000)
	private String ownerPhone;//权属人联系电话（接口新增）

	@Temporal(TemporalType.TIMESTAMP)
	private Date examineTime;//审批时间（接口新增）
	@Column(length = 200)
	private String publishNo;//发布编号（接口新增）
	@Column(length = 32)
	private String isPercent;//房屋建设工程是否完成投资总额的25%以上（接口新增）
	@Column(length = 32)
	private String isDevelope;//土地成片开发是否形成工业用地或其他建设用地条件（接口新增）
	@Column(length = 32)
	private String createUserName;//创建人（接口新增）
	@Column(length = 32)
	private String targetId;//标的ID（接口新增）
	@Column(length = 200)
	private String targetNo;//标的编号（接口新增）

	@Column(columnDefinition = "number(8)")
	private BigDecimal publishLsh;//发布流水号（接口新增）
	@Column(length = 32)
	private String noticeInterId;//公告id（接口新增）
	
	@Temporal(TemporalType.TIMESTAMP)
	private Date lastTime;//最后更新时间（接口新增）
	
	@Column(length = 32)
	private String wdid;//流程定义id
	
	@Column(length = 32)
	private String dBdcqszh;//不动产编号

	@Column(length = 32)
	private String mapImgFileId;//地图截屏id

	public TransResource(String resourceId, String publishTitle, Integer publishLandType, String provinceCode,
	                     String cityCode, String countyCode, String streetCode, String holderName, String publishUserId,
	                     Date createAt, Date updateDate, Date publishDate, Date transactionDate, String createUser,
	                     Integer publishStatus, Integer dealStatus, String coverinfo, Integer isIntroduction, Integer netType,
	                     String jyLx, Integer displayStatus, String processinstanceId, BigDecimal tdZmj, BigDecimal jyZmj,
	                     BigDecimal jyZje, String linkMan, String linkPhone, BigDecimal qwPrice, String landCoordinate,
	                     Integer underLineFlag, String landUseRight, Integer assessment, Integer assessmentType, String remarkReason,
	                     String landType, Date endDate, Integer years, String decisionNum, String adjunct, BigDecimal buildArea,
	                     String buildingStructure, String ownerShipNature, String ownerAddress, String ownerPhone, Date examineTime,
	                     String publishNo, String isPercent, String isDevelope, String createUserName, String targetId,
	                     String targetNo, BigDecimal publishLsh, String noticeInterId,String dBdcqszh,String mapImgFileId) {
		super();
		this.resourceId = resourceId;
		this.publishTitle = publishTitle;
		this.publishLandType = publishLandType;
		this.provinceCode = provinceCode;
		this.cityCode = cityCode;
		this.countyCode = countyCode;
		this.streetCode = streetCode;
		this.holderName = holderName;
		this.publishUserId = publishUserId;
		this.createAt = createAt;
		this.updateDate = updateDate;
		this.publishDate = publishDate;
		this.transactionDate = transactionDate;
		this.createUser = createUser;
		this.publishStatus = publishStatus;
		this.dealStatus = dealStatus;
		this.coverinfo = coverinfo;
		this.isIntroduction = isIntroduction;
		this.netType = netType;
		this.jyLx = jyLx;
		this.displayStatus = displayStatus;
		this.processinstanceId = processinstanceId;
		this.tdZmj = tdZmj;
		this.jyZmj = jyZmj;
		this.jyZje = jyZje;
		this.linkMan = linkMan;
		this.linkPhone = linkPhone;
		this.qwPrice = qwPrice;
		this.landCoordinate = landCoordinate;
		this.underLineFlag = underLineFlag;
		this.landUseRight = landUseRight;
		this.assessment = assessment;
		this.assessmentType = assessmentType;
		this.remarkReason = remarkReason;
		this.landType = landType;
		this.endDate = endDate;
		this.years = years;
		this.decisionNum = decisionNum;
		this.adjunct = adjunct;
		this.buildArea = buildArea;
		this.buildingStructure = buildingStructure;
		this.ownerShipNature = ownerShipNature;
		this.ownerAddress = ownerAddress;
		this.ownerPhone = ownerPhone;
		this.examineTime = examineTime;
		this.publishNo = publishNo;
		this.isPercent = isPercent;
		this.isDevelope = isDevelope;
		this.createUserName = createUserName;
		this.targetId = targetId;
		this.targetNo = targetNo;
		this.publishLsh = publishLsh;
		this.noticeInterId = noticeInterId;
		this.dBdcqszh = dBdcqszh;
		this.mapImgFileId = mapImgFileId;
	}

	public TransResource() {
		super();
	}

	public String getResourceId() {
		return resourceId;
	}

	public void setResourceId(String resourceId) {
		this.resourceId = resourceId == null ? null : resourceId.trim();
	}

	public String getPublishTitle() {
		return publishTitle;
	}

	public void setPublishTitle(String publishTitle) {
		this.publishTitle = publishTitle == null ? null : publishTitle.trim();
	}

	public Integer getPublishLandType() {
		return publishLandType;
	}

	public void setPublishLandType(Integer publishLandType) {
		this.publishLandType = publishLandType;
	}

	public String getProvinceCode() {
		return provinceCode;
	}

	public void setProvinceCode(String provinceCode) {
		this.provinceCode = provinceCode == null ? null : provinceCode.trim();
	}

	public String getCityCode() {
		return cityCode;
	}

	public void setCityCode(String cityCode) {
		this.cityCode = cityCode == null ? null : cityCode.trim();
	}

	public String getCountyCode() {
		return countyCode;
	}

	public void setCountyCode(String countyCode) {
		this.countyCode = countyCode == null ? null : countyCode.trim();
	}

	public String getStreetCode() {
		return streetCode;
	}

	public void setStreetCode(String streetCode) {
		this.streetCode = streetCode == null ? null : streetCode.trim();
	}

	public String getHolderName() {
		return holderName;
	}

	public void setHolderName(String holderName) {
		this.holderName = holderName == null ? null : holderName.trim();
	}

	public String getPublishUserId() {
		return publishUserId;
	}

	public void setPublishUserId(String publishUserId) {
		this.publishUserId = publishUserId == null ? null : publishUserId.trim();
	}

	public Date getCreateAt() {
		return createAt;
	}

	public void setCreateAt(Date createAt) {
		this.createAt = createAt;
	}

	public Date getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public Date getPublishDate() {
		return publishDate;
	}

	public void setPublishDate(Date publishDate) {
		this.publishDate = publishDate;
	}

	public Date getTransactionDate() {
		return transactionDate;
	}

	public void setTransactionDate(Date transactionDate) {
		this.transactionDate = transactionDate;
	}

	public String getCreateUser() {
		return createUser;
	}

	public void setCreateUser(String createUser) {
		this.createUser = createUser == null ? null : createUser.trim();
	}

	public Integer getPublishStatus() {
		return publishStatus;
	}

	public void setPublishStatus(Integer publishStatus) {
		this.publishStatus = publishStatus;
	}

	public Integer getDealStatus() {
		return dealStatus;
	}

	public void setDealStatus(Integer dealStatus) {
		this.dealStatus = dealStatus;
	}

	public String getCoverinfo() {
		return coverinfo;
	}

	public void setCoverinfo(String coverinfo) {
		this.coverinfo = coverinfo == null ? null : coverinfo.trim();
	}

	public Integer getIsIntroduction() {
		return isIntroduction;
	}

	public void setIsIntroduction(Integer isIntroduction) {
		this.isIntroduction = isIntroduction;
	}

	public Integer getNetType() {
		return netType;
	}

	public void setNetType(Integer netType) {
		this.netType = netType;
	}

	public String getJyLx() {
		return jyLx;
	}

	public void setJyLx(String jyLx) {
		this.jyLx = jyLx == null ? null : jyLx.trim();
	}

	public Integer getDisplayStatus() {
		return displayStatus;
	}

	public void setDisplayStatus(Integer displayStatus) {
		this.displayStatus = displayStatus;
	}

	public String getProcessinstanceId() {
		return processinstanceId;
	}

	public void setProcessinstanceId(String processinstanceId) {
		this.processinstanceId = processinstanceId == null ? null : processinstanceId.trim();
	}

	public BigDecimal getTdZmj() {
		return tdZmj;
	}

	public void setTdZmj(BigDecimal tdZmj) {
		this.tdZmj = tdZmj;
	}

	public BigDecimal getJyZmj() {
		return jyZmj;
	}

	public void setJyZmj(BigDecimal jyZmj) {
		this.jyZmj = jyZmj;
	}

	public BigDecimal getJyZje() {
		return jyZje;
	}

	public void setJyZje(BigDecimal jyZje) {
		this.jyZje = jyZje;
	}

	public String getLinkMan() {
		return linkMan;
	}

	public void setLinkMan(String linkMan) {
		this.linkMan = linkMan == null ? null : linkMan.trim();
	}

	public String getLinkPhone() {
		return linkPhone;
	}

	public void setLinkPhone(String linkPhone) {
		this.linkPhone = linkPhone == null ? null : linkPhone.trim();
	}

	public BigDecimal getQwPrice() {
		return qwPrice;
	}

	public void setQwPrice(BigDecimal qwPrice) {
		this.qwPrice = qwPrice;
	}

	public String getLandCoordinate() {
		return landCoordinate;
	}

	public void setLandCoordinate(String landCoordinate) {
		this.landCoordinate = landCoordinate == null ? null : landCoordinate.trim();
	}

	public Integer getUnderLineFlag() {
		return underLineFlag;
	}

	public void setUnderLineFlag(Integer underLineFlag) {
		this.underLineFlag = underLineFlag;
	}

	public String getLandUseRight() {
		return landUseRight;
	}

	public void setLandUseRight(String landUseRight) {
		this.landUseRight = landUseRight;
	}

	public Integer getAssessment() {
		return assessment;
	}

	public void setAssessment(Integer assessment) {
		this.assessment = assessment;
	}

	public Integer getAssessmentType() {
		return assessmentType;
	}

	public void setAssessmentType(Integer assessmentType) {
		this.assessmentType = assessmentType;
	}

	public String getRemarkReason() {
		return remarkReason;
	}

	public void setRemarkReason(String remarkReason) {
		this.remarkReason = remarkReason;
	}

	public String getLandType() {
		return landType;
	}

	public void setLandType(String landType) {
		this.landType = landType;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Integer getYears() {
		return years;
	}

	public void setYears(Integer years) {
		this.years = years;
	}

	public String getDecisionNum() {
		return decisionNum;
	}

	public void setDecisionNum(String decisionNum) {
		this.decisionNum = decisionNum;
	}

	public String getAdjunct() {
		return adjunct;
	}

	public void setAdjunct(String adjunct) {
		this.adjunct = adjunct;
	}

	public BigDecimal getBuildArea() {
		return buildArea;
	}

	public void setBuildArea(BigDecimal buildArea) {
		this.buildArea = buildArea;
	}

	public String getBuildingStructure() {
		return buildingStructure;
	}

	public void setBuildingStructure(String buildingStructure) {
		this.buildingStructure = buildingStructure;
	}

	public String getOwnerShipNature() {
		return ownerShipNature;
	}

	public void setOwnerShipNature(String ownerShipNature) {
		this.ownerShipNature = ownerShipNature;
	}

	public String getOwnerAddress() {
		return ownerAddress;
	}

	public void setOwnerAddress(String ownerAddress) {
		this.ownerAddress = ownerAddress;
	}

	public String getOwnerPhone() {
		return ownerPhone;
	}

	public void setOwnerPhone(String ownerPhone) {
		this.ownerPhone = ownerPhone;
	}

	public Date getExamineTime() {
		return examineTime;
	}

	public void setExamineTime(Date examineTime) {
		this.examineTime = examineTime;
	}

	public String getPublishNo() {
		return publishNo;
	}

	public void setPublishNo(String publishNo) {
		this.publishNo = publishNo;
	}

	public String getIsPercent() {
		return isPercent;
	}

	public void setIsPercent(String isPercent) {
		this.isPercent = isPercent;
	}

	public String getIsDevelope() {
		return isDevelope;
	}

	public void setIsDevelope(String isDevelope) {
		this.isDevelope = isDevelope;
	}

	public String getCreateUserName() {
		return createUserName;
	}

	public void setCreateUserName(String createUserName) {
		this.createUserName = createUserName;
	}

	public String getTargetId() {
		return targetId;
	}

	public void setTargetId(String targetId) {
		this.targetId = targetId;
	}

	public String getTargetNo() {
		return targetNo;
	}

	public void setTargetNo(String targetNo) {
		this.targetNo = targetNo;
	}

	public BigDecimal getPublishLsh() {
		return publishLsh;
	}

	public void setPublishLsh(BigDecimal publishLsh) {
		this.publishLsh = publishLsh;
	}

	public String getNoticeInterId() {
		return noticeInterId;
	}

	public void setNoticeInterId(String noticeInterId) {
		this.noticeInterId = noticeInterId;
	}
	
	public Date getLastTime() {
		return lastTime;
	}

	public void setLastTime(Date lastTime) {
		this.lastTime = lastTime;
	}

	public String getWdid() {
		return wdid;
	}

	public void setWdid(String wdid) {
		this.wdid = wdid;
	}

	public String getGgId() {
		return ggId;
	}

	public void setGgId(String ggId) {
		this.ggId = ggId;
	}

	/**
	 * @return the dBdcqszh
	 */
	public String getdBdcqszh() {
		return dBdcqszh;
	}

	/**
	 * @param dBdcqszh the dBdcqszh to set
	 */
	public void setdBdcqszh(String dBdcqszh) {
		this.dBdcqszh = dBdcqszh;
	}

	public String getMapImgFileId() {
		return mapImgFileId;
	}

	public void setMapImgFileId(String mapImgFileId) {
		this.mapImgFileId = mapImgFileId;
	}
}
