package cn.gtmap.secondaryMarket.common.domain;

import javax.persistence.*;
import java.util.Date;

/**
 * 中介机构服务
 * @author cxm
 * @version v1.0, 2018/7/11
 */
@Entity
@Table(name = "trans_organization")
public class TransOrganization {

    @Id
    @Column(length = 32)
    private String organizationId;//主键id
    @Column
    private Integer organizationType;//机构类型 0中介机构  1评估机构 2测绘服务 3法律咨询 4金融服务 5担保服务 6税务服务
    @Column(length = 200)
    private String organizationName;//机构名称
    @Column(length = 200)
    private String organizationAddress;//机构地址
    @Column(length = 200)
    private String organizationScope;//经营范围
    @Column(length = 200)
    private String organizationCaptial;//注册资金
    @Column(length = 200)
    private String organizationLinkName;//法人代表
    @Column(length = 200)
    private String organizationPhone;//联系电话
    @Column(length = 200)
    private String organizationNote;//备注
    @Temporal(TemporalType.TIMESTAMP)
    private Date createTime;
    @Column
    private Integer publishStatus;
    @Column(length = 200)
    private String userId;
    public TransOrganization(String organizationId, Integer organizationType, String organizationName, String organizationAddress, String organizationScope, String organizationCaptial, String organizationLinkName, String organizationPhone, String organizationNote, Date createTime, Integer publishStatus, String userId) {
        this.organizationId = organizationId;
        this.organizationType = organizationType;
        this.organizationName = organizationName;
        this.organizationAddress = organizationAddress;
        this.organizationScope = organizationScope;
        this.organizationCaptial = organizationCaptial;
        this.organizationLinkName = organizationLinkName;
        this.organizationPhone = organizationPhone;
        this.organizationNote = organizationNote;
        this.createTime = createTime;
        this.publishStatus=publishStatus;
        this.userId=userId;
    }

    public TransOrganization() {
        super();
    }

    public String getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Integer getOrganizationType() {
        return organizationType;
    }

    public void setOrganizationType(Integer organizationType) {
        this.organizationType = organizationType;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrganizationAddress() {
        return organizationAddress;
    }

    public void setOrganizationAddress(String organizationAddress) {
        this.organizationAddress = organizationAddress;
    }

    public String getOrganizationScope() {
        return organizationScope;
    }

    public void setOrganizationScope(String organizationScope) {
        this.organizationScope = organizationScope;
    }

    public String getOrganizationCaptial() {
        return organizationCaptial;
    }

    public void setOrganizationCaptial(String organizationCaptial) {
        this.organizationCaptial = organizationCaptial;
    }

    public String getOrganizationLinkName() {
        return organizationLinkName;
    }

    public void setOrganizationLinkName(String organizationLinkName) {
        this.organizationLinkName = organizationLinkName;
    }

    public String getOrganizationPhone() {
        return organizationPhone;
    }

    public void setOrganizationPhone(String organizationPhone) {
        this.organizationPhone = organizationPhone;
    }

    public String getOrganizationNote() {
        return organizationNote;
    }

    public void setOrganizationNote(String organizationNote) {
        this.organizationNote = organizationNote;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getPublishStatus() {
        return publishStatus;
    }

    public void setPublishStatus(Integer publishStatus) {
        this.publishStatus = publishStatus;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
