package cn.gtmap.secondaryMarket.common.domain;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * 土地需求信息
 * @author zhujunjie
 */
@Entity
@Table(name = "trans_land_demand")
public class TransLandDemand {

	@Id
	@Column(length = 32)
    private String demandId;

	@Column(length = 32)
    private String resourceId;

	@Column(length = 64)
    private String provinceCode;

	@Column(length = 64)
    private String cityCode;

	@Column(length = 64)
    private String countyCode;

	@Column(length = 64)
    private String streetCode;

	@Column(length = 64)
    private String landTypeBig;

	@Column(length = 64)
    private String landTypeSmall;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
    private BigDecimal residentialBuildingArea;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
    private BigDecimal commercialBuildingArea;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
    private BigDecimal factoryBuildingArea;

	@Temporal(TemporalType.TIMESTAMP)
    private Date useDuration;

	@Column(length = 64)
    private String linkMan;

	@Column(length = 32)
    private String contactNumber;

	@Column(length = 128)
    private String publishTitle;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
    private BigDecimal landArea;

	@Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
    private BigDecimal landPrice;

	@Column(columnDefinition = "number")
    private BigDecimal circulationType;

	@Column(length = 500)
    private String explain;

	@Column(length = 500)
    private String landAttachment;

	@Temporal(TemporalType.TIMESTAMP)
    private Date publishDate;

	@Temporal(TemporalType.TIMESTAMP)
    private Date transactionDate;

	@Temporal(TemporalType.TIMESTAMP)
    private Date updateDate;

	@Temporal(TemporalType.TIMESTAMP)
    private Date createAt;

	@Column(length = 32)
    private String createUser;

	@Column(columnDefinition = "number")
    private BigDecimal publishStatus;

	@Column(columnDefinition = "number")
    private BigDecimal dealStatus;

	@Column(length = 4000)
    private String coverinfo;

	@Column(columnDefinition = "number")
    private BigDecimal exportStatus;

	@Column(columnDefinition = "number")
    private BigDecimal publishLandType;

	@Column(length = 128)
    private String detailAddress;

    @Column(length = 4000)
    private String attachinfo;
    
    @Temporal(TemporalType.TIMESTAMP)
    private Date useBeginDate;//使用开始时间（接口新增）

    @Temporal(TemporalType.TIMESTAMP)
    private Date useEndDate;//使用截止时间（接口新增）

    @Column(length = 500)
    private String address;//联系地址（接口新增）

    @Column(length = 32)
    private String publishNo;//发布编号（接口新增）

    @Column(length = 32)
    private String createUserId;//创建用户名称（接口新增）

    @Column(precision = 18, scale = 6, columnDefinition = "number(18,6)")
    private BigDecimal areaMax;//土地面积上限（接口新增）
    
    @Column(columnDefinition = "number(8)")
    private BigDecimal publishLsh;//发布流水号（接口新增）
    
    @Temporal(TemporalType.TIMESTAMP)
    private Date lastTime;//最后更新时间（接口新增）

	public TransLandDemand(String demandId, String resourceId, String provinceCode, String cityCode, String countyCode, String streetCode, String landTypeBig, String landTypeSmall, BigDecimal residentialBuildingArea, BigDecimal commercialBuildingArea, BigDecimal factoryBuildingArea, Date useDuration, String linkMan, String contactNumber, String publishTitle, BigDecimal landArea, BigDecimal landPrice, BigDecimal circulationType, String explain, String landAttachment, Date publishDate, Date transactionDate, Date updateDate, Date createAt, String createUser, BigDecimal publishStatus, BigDecimal dealStatus, String coverinfo, BigDecimal exportStatus, BigDecimal publishLandType, String detailAddress, String attachinfo, Date useBeginDate, Date useEndDate, String address, String publishNo,
			String createUserId, BigDecimal areaMax) {
        this.demandId = demandId;
        this.resourceId = resourceId;
        this.provinceCode = provinceCode;
        this.cityCode = cityCode;
        this.countyCode = countyCode;
        this.streetCode = streetCode;
        this.landTypeBig = landTypeBig;
        this.landTypeSmall = landTypeSmall;
        this.residentialBuildingArea = residentialBuildingArea;
        this.commercialBuildingArea = commercialBuildingArea;
        this.factoryBuildingArea = factoryBuildingArea;
        this.useDuration = useDuration;
        this.linkMan = linkMan;
        this.contactNumber = contactNumber;
        this.publishTitle = publishTitle;
        this.landArea = landArea;
        this.landPrice = landPrice;
        this.circulationType = circulationType;
        this.explain = explain;
        this.landAttachment = landAttachment;
        this.publishDate = publishDate;
        this.transactionDate = transactionDate;
        this.updateDate = updateDate;
        this.createAt = createAt;
        this.createUser = createUser;
        this.publishStatus = publishStatus;
        this.dealStatus = dealStatus;
        this.coverinfo = coverinfo;
        this.exportStatus = exportStatus;
        this.publishLandType = publishLandType;
        this.detailAddress = detailAddress;
        this.attachinfo = attachinfo;
        this.useBeginDate = useBeginDate;
		this.useEndDate = useEndDate;
		this.address = address;
		this.publishNo = publishNo;
		this.createUserId = createUserId;
		this.areaMax = areaMax;
    }

    public TransLandDemand() {
        super();
    }

    public String getDemandId() {
        return demandId;
    }

    public void setDemandId(String demandId) {
        this.demandId = demandId == null ? null : demandId.trim();
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId == null ? null : resourceId.trim();
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode == null ? null : provinceCode.trim();
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode == null ? null : cityCode.trim();
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode == null ? null : countyCode.trim();
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode == null ? null : streetCode.trim();
    }

    public String getLandTypeBig() {
        return landTypeBig;
    }

    public void setLandTypeBig(String landTypeBig) {
        this.landTypeBig = landTypeBig == null ? null : landTypeBig.trim();
    }

    public String getLandTypeSmall() {
        return landTypeSmall;
    }

    public void setLandTypeSmall(String landTypeSmall) {
        this.landTypeSmall = landTypeSmall == null ? null : landTypeSmall.trim();
    }

    public BigDecimal getResidentialBuildingArea() {
        return residentialBuildingArea;
    }

    public void setResidentialBuildingArea(BigDecimal residentialBuildingArea) {
        this.residentialBuildingArea = residentialBuildingArea;
    }

    public BigDecimal getCommercialBuildingArea() {
        return commercialBuildingArea;
    }

    public void setCommercialBuildingArea(BigDecimal commercialBuildingArea) {
        this.commercialBuildingArea = commercialBuildingArea;
    }

    public BigDecimal getFactoryBuildingArea() {
        return factoryBuildingArea;
    }

    public void setFactoryBuildingArea(BigDecimal factoryBuildingArea) {
        this.factoryBuildingArea = factoryBuildingArea;
    }

    public Date getUseDuration() {
        return useDuration;
    }

    public void setUseDuration(Date useDuration) {
        this.useDuration = useDuration;
    }

    public String getLinkMan() {
        return linkMan;
    }

    public void setLinkMan(String linkMan) {
        this.linkMan = linkMan == null ? null : linkMan.trim();
    }

    public String getContactNumber() {
        return contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber == null ? null : contactNumber.trim();
    }

    public String getPublishTitle() {
        return publishTitle;
    }

    public void setPublishTitle(String publishTitle) {
        this.publishTitle = publishTitle == null ? null : publishTitle.trim();
    }

    public BigDecimal getLandArea() {
        return landArea;
    }

    public void setLandArea(BigDecimal landArea) {
        this.landArea = landArea;
    }

    public BigDecimal getLandPrice() {
        return landPrice;
    }

    public void setLandPrice(BigDecimal landPrice) {
        this.landPrice = landPrice;
    }

    public BigDecimal getCirculationType() {
        return circulationType;
    }

    public void setCirculationType(BigDecimal circulationType) {
        this.circulationType = circulationType;
    }

    public String getExplain() {
        return explain;
    }

    public void setExplain(String explain) {
        this.explain = explain == null ? null : explain.trim();
    }

    public String getLandAttachment() {
        return landAttachment;
    }

    public void setLandAttachment(String landAttachment) {
        this.landAttachment = landAttachment == null ? null : landAttachment.trim();
    }

    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public Date getTransactionDate() {
        return transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public BigDecimal getPublishStatus() {
        return publishStatus;
    }

    public void setPublishStatus(BigDecimal publishStatus) {
        this.publishStatus = publishStatus;
    }

    public BigDecimal getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(BigDecimal dealStatus) {
        this.dealStatus = dealStatus;
    }

    public String getCoverinfo() {
        return coverinfo;
    }

    public void setCoverinfo(String coverinfo) {
        this.coverinfo = coverinfo == null ? null : coverinfo.trim();
    }

    public BigDecimal getExportStatus() {
        return exportStatus;
    }

    public void setExportStatus(BigDecimal exportStatus) {
        this.exportStatus = exportStatus;
    }

    public BigDecimal getPublishLandType() {
        return publishLandType;
    }

    public void setPublishLandType(BigDecimal publishLandType) {
        this.publishLandType = publishLandType;
    }

    public String getDetailAddress() {
        return detailAddress;
    }

    public void setDetailAddress(String detailAddress) {
        this.detailAddress = detailAddress == null ? null : detailAddress.trim();
    }

    public String getAttachinfo() {
        return attachinfo;
    }

    public void setAttachinfo(String attachinfo) {
        this.attachinfo = attachinfo == null ? null : attachinfo.trim();
    }

	public Date getUseBeginDate() {
		return useBeginDate;
	}

	public void setUseBeginDate(Date useBeginDate) {
		this.useBeginDate = useBeginDate;
	}

	public Date getUseEndDate() {
		return useEndDate;
	}

	public void setUseEndDate(Date useEndDate) {
		this.useEndDate = useEndDate;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getPublishNo() {
		return publishNo;
	}

	public void setPublishNo(String publishNo) {
		this.publishNo = publishNo;
	}

	public String getCreateUserId() {
		return createUserId;
	}

	public void setCreateUserId(String createUserId) {
		this.createUserId = createUserId;
	}

	public BigDecimal getAreaMax() {
		return areaMax;
	}

	public void setAreaMax(BigDecimal areaMax) {
		this.areaMax = areaMax;
	}

	public BigDecimal getPublishLsh() {
		return publishLsh;
	}

	public void setPublishLsh(BigDecimal publishLsh) {
		this.publishLsh = publishLsh;
	}

	public Date getLastTime() {
		return lastTime;
	}

	public void setLastTime(Date lastTime) {
		this.lastTime = lastTime;
	}
	
}