package cn.gtmap.secondaryMarket.common.domain;



import cn.gtmap.secondaryMarket.common.format.DateDeserializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import javax.persistence.*;
import java.util.Date;

/**
 * @描述 新合同表 
 * @作者 卜祥东
 * @创建日期 2021年10月10日 
 * @创建时间 上午11:13:57
 * @版本号 V 1.0
 */
@Entity
@Table(name = "trans_contract_st")
public class TransContractSt {
	private static final long serialVersionUID = 1L;
	@Id
    @Column(length = 64)
	@Comment("主键")
	private String id;
	
	@Column(length = 64)
	@Comment("关联供给地块id")
	private String relationId;
	
	@Column(length = 64)
	@Comment("新增用户")
	private String insertUser; 
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("新增时间")
	private Date insertTime; 
	
	@Column(length = 64)
	@Comment("更新用户")
	private String updateUser; 
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("更新时间")
	private Date updateTime; 
	
	@Column(nullable = false,columnDefinition ="number(2) default '0'")
	@Comment("是否删除（0:物理删除1:逻辑删除）")
	private Integer deleteFlag; 
	
	@Column(length = 64)
	@Comment("合同类型（0:转让1:出租2:抵押）")
	private Integer contractType; 
	
	@Column(nullable = false,columnDefinition ="number(2) default '0'")
	@Comment("合同状态（0:草稿1:提交审核2:审核不通过3:审核通过4.完成审批5.审核中）")
	private Integer contractStatus; 
	
	@Column(length = 1000)
	@Comment("合同审核意见（不通过的原因）")
	private String contractShyj; 
	
	@Column(length = 200)
	@Comment("合同编号")
	private String contractNo; 
	
	@Column(length = 200)
	@Comment("是否归档(0:未归档1：归档)")
	private Integer fileFlag; 
	
	//甲方
	@Column(length = 200)
	@Comment("转让方(甲方)")
	private String jZrf;
	
	@Column(length = 200)
	@Comment("证件类型")
	private String jZjlx;
	
	@Column(length = 200)
	@Comment("证件号码")
	private String jZjhm;
	
	@Column(length = 200)
	@Comment("法定代表人")
	private String jFddbr;
	
	@Column(length = 200)
	@Comment("身份证号")
	private String jSfzh;
	
	@Column(length = 1000)
	@Comment("法定地址")
	private String jFddz;
	
	@Column(length = 1000)
	@Comment("通讯地址")
	private String jTxdz;
	
	@Column(length = 200)
	@Comment("委托代理人")
	private String jWtdkr;
	
	@Column(length = 200)
	@Comment("委托代理人-身份证号")
	private String jWtdkrSfzh;
	
	@Column(length = 200)
	@Comment("联系电话")
	private String jLxdh;
	
	@Column(length = 200)
	@Comment("邮政编码")
	private String jYzbm;
	
	@Column(length = 200)
	@Comment("银行账号")
	private String jYhzh;
	
	//乙方
	@Column(length = 200)
	@Comment("受让方(乙方)")
	private String yZrf;
	
	@Column(length = 200)
	@Comment("证件类型")
	private String yZjlx;
	
	@Column(length = 200)
	@Comment("证件号码")
	private String yZjhm;
	
	@Column(length = 200)
	@Comment("法定代表人")
	private String yFddbr;
	
	@Column(length = 200)
	@Comment("身份证号")
	private String ySfzh;
	
	@Column(length = 1000)
	@Comment("法定地址")
	private String yFddz;
	
	@Column(length = 1000)
	@Comment("通讯地址")
	private String yTxdz;
	
	@Column(length = 200)
	@Comment("委托代理人")
	private String yWtdkr;
	
	@Column(length = 200)
	@Comment("委托代理人-身份证号")
	private String yWtdkrSfzh;
	
	@Column(length = 200)
	@Comment("联系电话")
	private String yLxdh;
	
	@Column(length = 200)
	@Comment("邮政编码")
	private String yYzbm;
	
	@Column(length = 200)
	@Comment("银行账号")
	private String yYhzh;
	
	//地块基本信息
	@Column(length = 1000)
	@Comment("土地坐落")
	private String dTdzl;
	
	@Column(length = 200)
	@Comment("不动产权属证号")
	private String dBdcqszh;
	
	@Column(length = 200)
	@Comment("权利类型")
	private String dQslx;
	
	@Column(length = 200)
	@Comment("权利性质/土地性质")
	private String dQsxz;
	
	@Column(length = 500)
	@Comment("不动产单元号")
	private String dBdcdyh;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("土地登记面积（㎡）")
	private Double dTddjmj;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("转让土地面积（㎡）")
	private Double dZrtdmj;
	
	@Column(length = 200)
	@Comment("土地用途")
	private String dTdyt;
	
	@Column(length = 200)
	@Comment("土地用途一级")
	private String dTdytOne;
	
	@Column(length = 200)
	@Comment("土地用途二级")
	private String dTdytTwo;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("土地使用年限开始")
	private Date dTdsynxBegin;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("土地使用年限结束")
	private Date dTdsynxEnd;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("转让建筑物面积（㎡）")
	private Double dZrjzwmj;
	
	@Column(length = 4000)
	@Comment("地上建筑物情况")
	private String dDsjzwqk;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("转让总价款(元),租金总金额（元）,担保债权数额/最高债权数额（万元）")
	private Double dZrzjk;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("租金单价（元/㎡）")
	private Double dZjfs;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("土地使用权总金额(元)/土地使用权评估价值(元)")
	private Double dTdsyqzje;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("地上建筑物及附着物总金额(元)")
	private Double dDsjzwjfzwzje;
	
	@Column(length = 200)
	@Comment("付款方式/抵押类型")
	private String dfkfs;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("宗地交付时间")
	private Date dZdjfsj;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("地块-抵押或出租期限开始")
	private Date dDyqxBegin;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("地块-抵押或出租期限结束")
	private Date dDyqxEnd;
	
	@Column(length = 200)
	@Comment("转让方式（协议转让、公开转让）/抵押期限单位（年、月）")
	private String dZrfs;
	
	@Column(length = 200)
	@Comment("一次性付清天数")
	private Integer dYcxfqts; 
	
	@Column(length = 200)
	@Comment("定金付清天数")
	private Integer dDjfqts; 
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("定金付清金额")
	private Double dDjfqje;
	
	@Column(length = 200)
	@Comment("剩余付清天数")
	private Integer dSyfqts; 
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("剩余付清金额")
	private Double dSyfqje;
	
	@Column(length = 200)
	@Comment("分期期数")
	private Integer dFqqs; 
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("分期第一期金额")
	private Double dFqdyqje;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("分期第一期截止时间")
	private Date dFqdyqjzsj;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("分期第二期金额")
	private Double dFqdeqje;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("分期第二期截止时间")
	private Date dFqdeqjzsj;
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("分期第三期金额")
	private Double dFqdsqje;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("分期第三期截止时间")
	private Date dFqdsqjzsj;
	
	@Column(length = 200)
	@Comment("土地权属转移登记天数")
	private Integer dTdqszydjts; 
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("甲方违约滞纳金比例（%）/变现率%")
	private Double dJfwyznjbl;
	
	@Column(length = 200)
	@Comment("甲方违约滞纳金延期支付月数")
	private Integer dJfwyznjyqzfys; 
	
	@Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("乙方违约滞纳金比例（%）")
	private Double dYfwyznjbl;
	
	@Column(length = 200)
	@Comment("乙方违约滞纳金延期支付月数")
	private Integer dYfwyznjyqzfys; 
	
	@Column(length = 200)
	@Comment("合同争议约定解决方式（向人民法院起诉，向仲裁委员会申请仲裁）")
	private String dHtzyydjjfs;

	@Column(nullable = false,columnDefinition ="number(2) default '0'")
	@Comment("合同模板")
	private Integer sort;

	@Column(length = 200)
	@Comment("人民法院名称")
	private String dRmfymc;
	
	@Column(length = 200)
	@Comment("仲裁委员会名称")
	private String dZcwyhmc;
	
	@Temporal(TemporalType.TIMESTAMP)
    @Column
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
	@Comment("签订时间")
	private Date dQdsj;
	
	@Column(length = 200)
	@Comment("签订地点")
	private String dQddd;
	
	@Column(length = 200)
	@Comment("鉴证机关")
	private String dJzjg;
	
	@Column(length = 200)
	@Comment("合同份数")
	private Integer dHtfs; 
	
	@Column(length = 200)
	@Comment("甲方合同份数")
	private Integer dJfhtfs; 
	
	@Column(length = 200)
	@Comment("乙方合同份数")
	private Integer dYfhtfs; 
	
	@Column(length = 200)
	@Comment("不动产类型")
	private String bdclx; 

	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getRelationId() {
		return relationId;
	}
	public void setRelationId(String relationId) {
		this.relationId = relationId;
	}
	public String getInsertUser() {
		return insertUser;
	}
	public void setInsertUser(String insertUser) {
		this.insertUser = insertUser;
	}
	public Date getInsertTime() {
		return insertTime;
	}
	public void setInsertTime(Date insertTime) {
		this.insertTime = insertTime;
	}
	public String getUpdateUser() {
		return updateUser;
	}
	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}
	public Date getUpdateTime() {
		return updateTime;
	}
	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}
	public Integer getDeleteFlag() {
		return deleteFlag;
	}
	public void setDeleteFlag(Integer deleteFlag) {
		this.deleteFlag = deleteFlag;
	}
	public Integer getContractStatus() {
		return contractStatus;
	}
	public void setContractStatus(Integer contractStatus) {
		this.contractStatus = contractStatus;
	}
	public String getContractShyj() {
		return contractShyj;
	}
	public void setContractShyj(String contractShyj) {
		this.contractShyj = contractShyj;
	}
	public String getContractNo() {
		return contractNo;
	}
	public void setContractNo(String contractNo) {
		this.contractNo = contractNo;
	}
	public String getjZrf() {
		return jZrf;
	}
	public void setjZrf(String jZrf) {
		this.jZrf = jZrf;
	}
	public String getjZjlx() {
		return jZjlx;
	}
	public void setjZjlx(String jZjlx) {
		this.jZjlx = jZjlx;
	}
	public String getjZjhm() {
		return jZjhm;
	}
	public void setjZjhm(String jZjhm) {
		this.jZjhm = jZjhm;
	}
	public String getjFddbr() {
		return jFddbr;
	}
	public void setjFddbr(String jFddbr) {
		this.jFddbr = jFddbr;
	}
	public String getjSfzh() {
		return jSfzh;
	}
	public void setjSfzh(String jSfzh) {
		this.jSfzh = jSfzh;
	}
	public String getjFddz() {
		return jFddz;
	}
	public void setjFddz(String jFddz) {
		this.jFddz = jFddz;
	}
	public String getjTxdz() {
		return jTxdz;
	}
	public void setjTxdz(String jTxdz) {
		this.jTxdz = jTxdz;
	}
	public String getjWtdkr() {
		return jWtdkr;
	}
	public void setjWtdkr(String jWtdkr) {
		this.jWtdkr = jWtdkr;
	}
	public String getjWtdkrSfzh() {
		return jWtdkrSfzh;
	}
	public void setjWtdkrSfzh(String jWtdkrSfzh) {
		this.jWtdkrSfzh = jWtdkrSfzh;
	}
	public String getjLxdh() {
		return jLxdh;
	}
	public void setjLxdh(String jLxdh) {
		this.jLxdh = jLxdh;
	}
	public String getjYzbm() {
		return jYzbm;
	}
	public void setjYzbm(String jYzbm) {
		this.jYzbm = jYzbm;
	}
	public String getyZrf() {
		return yZrf;
	}
	public void setyZrf(String yZrf) {
		this.yZrf = yZrf;
	}
	public String getyZjlx() {
		return yZjlx;
	}
	public void setyZjlx(String yZjlx) {
		this.yZjlx = yZjlx;
	}
	public String getyZjhm() {
		return yZjhm;
	}
	public void setyZjhm(String yZjhm) {
		this.yZjhm = yZjhm;
	}
	public String getyFddbr() {
		return yFddbr;
	}
	public void setyFddbr(String yFddbr) {
		this.yFddbr = yFddbr;
	}
	public String getySfzh() {
		return ySfzh;
	}
	public void setySfzh(String ySfzh) {
		this.ySfzh = ySfzh;
	}
	public String getyFddz() {
		return yFddz;
	}
	public void setyFddz(String yFddz) {
		this.yFddz = yFddz;
	}
	public String getyTxdz() {
		return yTxdz;
	}
	public void setyTxdz(String yTxdz) {
		this.yTxdz = yTxdz;
	}
	public String getyWtdkr() {
		return yWtdkr;
	}
	public void setyWtdkr(String yWtdkr) {
		this.yWtdkr = yWtdkr;
	}
	public String getyWtdkrSfzh() {
		return yWtdkrSfzh;
	}
	public void setyWtdkrSfzh(String yWtdkrSfzh) {
		this.yWtdkrSfzh = yWtdkrSfzh;
	}
	public String getyLxdh() {
		return yLxdh;
	}
	public void setyLxdh(String yLxdh) {
		this.yLxdh = yLxdh;
	}
	public String getyYzbm() {
		return yYzbm;
	}
	public void setyYzbm(String yYzbm) {
		this.yYzbm = yYzbm;
	}
	public String getdTdzl() {
		return dTdzl;
	}
	public void setdTdzl(String dTdzl) {
		this.dTdzl = dTdzl;
	}
	public String getdBdcqszh() {
		return dBdcqszh;
	}
	public void setdBdcqszh(String dBdcqszh) {
		this.dBdcqszh = dBdcqszh;
	}
	public String getdQslx() {
		return dQslx;
	}
	public void setdQslx(String dQslx) {
		this.dQslx = dQslx;
	}
	public String getdBdcdyh() {
		return dBdcdyh;
	}
	public void setdBdcdyh(String dBdcdyh) {
		this.dBdcdyh = dBdcdyh;
	}
	public Double getdTddjmj() {
		return dTddjmj;
	}
	public void setdTddjmj(Double dTddjmj) {
		this.dTddjmj = dTddjmj;
	}
	public Double getdZrtdmj() {
		return dZrtdmj;
	}
	public void setdZrtdmj(Double dZrtdmj) {
		this.dZrtdmj = dZrtdmj;
	}
	public String getdTdyt() {
		return dTdyt;
	}
	public void setdTdyt(String dTdyt) {
		this.dTdyt = dTdyt;
	}
	public String getdTdytOne() {
		return dTdytOne;
	}
	public void setdTdytOne(String dTdytOne) {
		this.dTdytOne = dTdytOne;
	}
	public String getdTdytTwo() {
		return dTdytTwo;
	}
	public void setdTdytTwo(String dTdytTwo) {
		this.dTdytTwo = dTdytTwo;
	}
	public Date getdTdsynxBegin() {
		return dTdsynxBegin;
	}
	public void setdTdsynxBegin(Date dTdsynxBegin) {
		this.dTdsynxBegin = dTdsynxBegin;
	}
	public Date getdTdsynxEnd() {
		return dTdsynxEnd;
	}
	public void setdTdsynxEnd(Date dTdsynxEnd) {
		this.dTdsynxEnd = dTdsynxEnd;
	}
	public Double getdZrjzwmj() {
		return dZrjzwmj;
	}
	public void setdZrjzwmj(Double dZrjzwmj) {
		this.dZrjzwmj = dZrjzwmj;
	}
	public String getdDsjzwqk() {
		return dDsjzwqk;
	}
	public void setdDsjzwqk(String dDsjzwqk) {
		this.dDsjzwqk = dDsjzwqk;
	}
	public Double getdZrzjk() {
		return dZrzjk;
	}
	public void setdZrzjk(Double dZrzjk) {
		this.dZrzjk = dZrzjk;
	}
	public Double getdTdsyqzje() {
		return dTdsyqzje;
	}
	public void setdTdsyqzje(Double dTdsyqzje) {
		this.dTdsyqzje = dTdsyqzje;
	}
	public Double getdDsjzwjfzwzje() {
		return dDsjzwjfzwzje;
	}
	public void setdDsjzwjfzwzje(Double dDsjzwjfzwzje) {
		this.dDsjzwjfzwzje = dDsjzwjfzwzje;
	}
	public String getDfkfs() {
		return dfkfs;
	}
	public void setDfkfs(String dfkfs) {
		this.dfkfs = dfkfs;
	}
	public Date getdZdjfsj() {
		return dZdjfsj;
	}
	public void setdZdjfsj(Date dZdjfsj) {
		this.dZdjfsj = dZdjfsj;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	/**
	 * @return the fileFlag
	 */
	public Integer getFileFlag() {
		return fileFlag;
	}
	/**
	 * @param fileFlag the fileFlag to set
	 */
	public void setFileFlag(Integer fileFlag) {
		this.fileFlag = fileFlag;
	}
	/**
	 * @return the contractType
	 */
	public Integer getContractType() {
		return contractType;
	}
	/**
	 * @param contractType the contractType to set
	 */
	public void setContractType(Integer contractType) {
		this.contractType = contractType;
	}
	/**
	 * @return the jYhzh
	 */
	public String getjYhzh() {
		return jYhzh;
	}
	/**
	 * @param jYhzh the jYhzh to set
	 */
	public void setjYhzh(String jYhzh) {
		this.jYhzh = jYhzh;
	}
	/**
	 * @return the yYhzh
	 */
	public String getyYhzh() {
		return yYhzh;
	}
	/**
	 * @param yYhzh the yYhzh to set
	 */
	public void setyYhzh(String yYhzh) {
		this.yYhzh = yYhzh;
	}
	/**
	 * @return the dZjfs
	 */
	public Double getdZjfs() {
		return dZjfs;
	}
	/**
	 * @param dZjfs the dZjfs to set
	 */
	public void setdZjfs(Double dZjfs) {
		this.dZjfs = dZjfs;
	}
	/**
	 * @return the dQsxz
	 */
	public String getdQsxz() {
		return dQsxz;
	}
	/**
	 * @param dQsxz the dQsxz to set
	 */
	public void setdQsxz(String dQsxz) {
		this.dQsxz = dQsxz;
	}
	/**
	 * @return the dDyqxBegin
	 */
	public Date getdDyqxBegin() {
		return dDyqxBegin;
	}
	/**
	 * @param dDyqxBegin the dDyqxBegin to set
	 */
	public void setdDyqxBegin(Date dDyqxBegin) {
		this.dDyqxBegin = dDyqxBegin;
	}
	/**
	 * @return the dDyqxEnd
	 */
	public Date getdDyqxEnd() {
		return dDyqxEnd;
	}
	/**
	 * @param dDyqxEnd the dDyqxEnd to set
	 */
	public void setdDyqxEnd(Date dDyqxEnd) {
		this.dDyqxEnd = dDyqxEnd;
	}
	/**
	 * @return the dZrfs
	 */
	public String getdZrfs() {
		return dZrfs;
	}
	/**
	 * @param dZrfs the dZrfs to set
	 */
	public void setdZrfs(String dZrfs) {
		this.dZrfs = dZrfs;
	}
	/**
	 * @return the dYcxfqts
	 */
	public Integer getdYcxfqts() {
		return dYcxfqts;
	}
	/**
	 * @param dYcxfqts the dYcxfqts to set
	 */
	public void setdYcxfqts(Integer dYcxfqts) {
		this.dYcxfqts = dYcxfqts;
	}
	/**
	 * @return the dDjfqts
	 */
	public Integer getdDjfqts() {
		return dDjfqts;
	}
	/**
	 * @param dDjfqts the dDjfqts to set
	 */
	public void setdDjfqts(Integer dDjfqts) {
		this.dDjfqts = dDjfqts;
	}
	/**
	 * @return the dDjfqje
	 */
	public Double getdDjfqje() {
		return dDjfqje;
	}
	/**
	 * @param dDjfqje the dDjfqje to set
	 */
	public void setdDjfqje(Double dDjfqje) {
		this.dDjfqje = dDjfqje;
	}
	/**
	 * @return the dSyfqts
	 */
	public Integer getdSyfqts() {
		return dSyfqts;
	}
	/**
	 * @param dSyfqts the dSyfqts to set
	 */
	public void setdSyfqts(Integer dSyfqts) {
		this.dSyfqts = dSyfqts;
	}
	/**
	 * @return the dSyfqje
	 */
	public Double getdSyfqje() {
		return dSyfqje;
	}
	/**
	 * @param dSyfqje the dSyfqje to set
	 */
	public void setdSyfqje(Double dSyfqje) {
		this.dSyfqje = dSyfqje;
	}
	/**
	 * @return the dFqqs
	 */
	public Integer getdFqqs() {
		return dFqqs;
	}
	/**
	 * @param dFqqs the dFqqs to set
	 */
	public void setdFqqs(Integer dFqqs) {
		this.dFqqs = dFqqs;
	}
	/**
	 * @return the dFqdyqje
	 */
	public Double getdFqdyqje() {
		return dFqdyqje;
	}
	/**
	 * @param dFqdyqje the dFqdyqje to set
	 */
	public void setdFqdyqje(Double dFqdyqje) {
		this.dFqdyqje = dFqdyqje;
	}
	/**
	 * @return the dFqdyqjzsj
	 */
	public Date getdFqdyqjzsj() {
		return dFqdyqjzsj;
	}
	/**
	 * @param dFqdyqjzsj the dFqdyqjzsj to set
	 */
	public void setdFqdyqjzsj(Date dFqdyqjzsj) {
		this.dFqdyqjzsj = dFqdyqjzsj;
	}
	/**
	 * @return the dFqdeqje
	 */
	public Double getdFqdeqje() {
		return dFqdeqje;
	}
	/**
	 * @param dFqdeqje the dFqdeqje to set
	 */
	public void setdFqdeqje(Double dFqdeqje) {
		this.dFqdeqje = dFqdeqje;
	}
	/**
	 * @return the dFqdeqjzsj
	 */
	public Date getdFqdeqjzsj() {
		return dFqdeqjzsj;
	}
	/**
	 * @param dFqdeqjzsj the dFqdeqjzsj to set
	 */
	public void setdFqdeqjzsj(Date dFqdeqjzsj) {
		this.dFqdeqjzsj = dFqdeqjzsj;
	}
	/**
	 * @return the dFqdsqje
	 */
	public Double getdFqdsqje() {
		return dFqdsqje;
	}
	/**
	 * @param dFqdsqje the dFqdsqje to set
	 */
	public void setdFqdsqje(Double dFqdsqje) {
		this.dFqdsqje = dFqdsqje;
	}
	/**
	 * @return the dFqdsqjzsj
	 */
	public Date getdFqdsqjzsj() {
		return dFqdsqjzsj;
	}
	/**
	 * @param dFqdsqjzsj the dFqdsqjzsj to set
	 */
	public void setdFqdsqjzsj(Date dFqdsqjzsj) {
		this.dFqdsqjzsj = dFqdsqjzsj;
	}
	public Integer getdTdqszydjts() {
		return dTdqszydjts;
	}
	public void setdTdqszydjts(Integer dTdqszydjts) {
		this.dTdqszydjts = dTdqszydjts;
	}
	public String getdHtzyydjjfs() {
		return dHtzyydjjfs;
	}
	public void setdHtzyydjjfs(String dHtzyydjjfs) {
		this.dHtzyydjjfs = dHtzyydjjfs;
	}
	public String getdRmfymc() {
		return dRmfymc;
	}
	public void setdRmfymc(String dRmfymc) {
		this.dRmfymc = dRmfymc;
	}
	public Date getdQdsj() {
		return dQdsj;
	}
	public void setdQdsj(Date dQdsj) {
		this.dQdsj = dQdsj;
	}
	public String getdQddd() {
		return dQddd;
	}
	public void setdQddd(String dQddd) {
		this.dQddd = dQddd;
	}
	public String getdJzjg() {
		return dJzjg;
	}
	public void setdJzjg(String dJzjg) {
		this.dJzjg = dJzjg;
	}
	public Integer getdHtfs() {
		return dHtfs;
	}
	public void setdHtfs(Integer dHtfs) {
		this.dHtfs = dHtfs;
	}
	public Integer getdJfhtfs() {
		return dJfhtfs;
	}
	public void setdJfhtfs(Integer dJfhtfs) {
		this.dJfhtfs = dJfhtfs;
	}
	public Integer getdYfhtfs() {
		return dYfhtfs;
	}
	public void setdYfhtfs(Integer dYfhtfs) {
		this.dYfhtfs = dYfhtfs;
	}
	public Double getdJfwyznjbl() {
		return dJfwyznjbl;
	}
	public void setdJfwyznjbl(Double dJfwyznjbl) {
		this.dJfwyznjbl = dJfwyznjbl;
	}
	public Integer getdJfwyznjyqzfys() {
		return dJfwyznjyqzfys;
	}
	public void setdJfwyznjyqzfys(Integer dJfwyznjyqzfys) {
		this.dJfwyznjyqzfys = dJfwyznjyqzfys;
	}
	public Double getdYfwyznjbl() {
		return dYfwyznjbl;
	}
	public void setdYfwyznjbl(Double dYfwyznjbl) {
		this.dYfwyznjbl = dYfwyznjbl;
	}
	public Integer getdYfwyznjyqzfys() {
		return dYfwyznjyqzfys;
	}
	public void setdYfwyznjyqzfys(Integer dYfwyznjyqzfys) {
		this.dYfwyznjyqzfys = dYfwyznjyqzfys;
	}
	public String getdZcwyhmc() {
		return dZcwyhmc;
	}
	public void setdZcwyhmc(String dZcwyhmc) {
		this.dZcwyhmc = dZcwyhmc;
	}

	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}
	/**
	 * @return the bdclx
	 */
	public String getBdclx() {
		return bdclx;
	}
	/**
	 * @param bdclx the bdclx to set
	 */
	public void setBdclx(String bdclx) {
		this.bdclx = bdclx;
	}
}
