package cn.gtmap.secondaryMarket.common.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * 配置表实体
 * @author zhujunjie
 */
@Entity
@Table(name = "trans_configure")
public class TransConfigure {
	
	@Id
	@Column(length = 32)
    private String configureId;

	@Column(length = 200)
    private String key;

	@Column(length = 200)
    private String value;

	@Column(length = 200)
    private String remark;

	@Temporal(TemporalType.TIMESTAMP)
    private Date createAt;
	
	@Lob
	@Column(columnDefinition="CLOB", nullable=true)
    private String xzqFeature;
	
	@Column(length = 32)
    private String isShow;

    public TransConfigure(String configureId, String key, String value, String remark, Date createAt, String xzqFeature, String isShow) {
        this.configureId = configureId;
        this.key = key;
        this.value = value;
        this.remark = remark;
        this.createAt = createAt;
        this.xzqFeature = xzqFeature;
        this.isShow = isShow;
    }

    public TransConfigure() {
        super();
    }

    public String getConfigureId() {
        return configureId;
    }

    public void setConfigureId(String configureId) {
        this.configureId = configureId == null ? null : configureId.trim();
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key == null ? null : key.trim();
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value == null ? null : value.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Date getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Date createAt) {
        this.createAt = createAt;
    }

	public String getXzqFeature() {
		return xzqFeature;
	}

	public void setXzqFeature(String xzqFeature) {
		this.xzqFeature = xzqFeature;
	}

	public String getIsShow() {
		return isShow;
	}

	public void setIsShow(String isShow) {
		this.isShow = isShow;
	}
    
}