package cn.gtmap.secondaryMarket.common.domain;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import cn.gtmap.egovplat.core.annotation.Field;
import cn.gtmap.egovplat.core.support.hibernate.UUIDHexGenerator;
import cn.gtmap.secondaryMarket.common.format.DateDeserializer;

/**
 * @描述 不动产信息实体类 
 * @作者 卜祥东
 * @创建日期 2022年1月17日 
 * @创建时间 下午2:29:37
 * @版本号 V 1.0
 */
@Entity
@Table(name = "trans_bdc")
public class TransBdc implements Serializable{
	private static final long serialVersionUID = 1L;
	@Id
    @GeneratedValue(generator = "sort-uuid")
    @GenericGenerator(name = "sort-uuid", strategy = UUIDHexGenerator.TYPE)
    @Column(length = 32)
    private String id;
    
	@Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
    @Field(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date createAt;
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(nullable = false)
	@Field(value = "更新时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	@JsonDeserialize(using = DateDeserializer.class)
	private Date updateAt;

    @Column(length = 200, nullable = false)
    @Field("姓名")
    private String userName;
    
    @Column(length = 200)
    @Field("证件号")
    private String certificateId;

    @Column(length = 50)
    @Field("不动产单元号")
    private String bdcdyh;
    
    @Column(length = 50)
    @Field("不动产权证号")
    private String bdcqzh;
    
    @Column(length = 200)
    @Field("坐落")
    private String zl;
    
    @Column(precision = 18,scale =6,columnDefinition ="number(18,6) default '0'")
	@Comment("面积（㎡）")
	private Double mj;
    
    @Column(precision = 1)
    @Field(value = "状态")
    private Integer status;
    
    
    @Column(length = 64)
	@Comment("业务类型（0:转让1:出租2:抵押）")
	private Integer busiType;


	public String getId() {
		return id;
	}


	public void setId(String id) {
		this.id = id;
	}


	public Date getCreateAt() {
		return createAt;
	}


	public void setCreateAt(Date createAt) {
		this.createAt = createAt;
	}


	public Date getUpdateAt() {
		return updateAt;
	}


	public void setUpdateAt(Date updateAt) {
		this.updateAt = updateAt;
	}


	public String getUserName() {
		return userName;
	}


	public void setUserName(String userName) {
		this.userName = userName;
	}


	public String getCertificateId() {
		return certificateId;
	}


	public void setCertificateId(String certificateId) {
		this.certificateId = certificateId;
	}


	public String getBdcdyh() {
		return bdcdyh;
	}


	public void setBdcdyh(String bdcdyh) {
		this.bdcdyh = bdcdyh;
	}


	public String getBdcqzh() {
		return bdcqzh;
	}


	public void setBdcqzh(String bdcqzh) {
		this.bdcqzh = bdcqzh;
	}


	public String getZl() {
		return zl;
	}


	public void setZl(String zl) {
		this.zl = zl;
	}


	public Double getMj() {
		return mj;
	}


	public void setMj(Double mj) {
		this.mj = mj;
	}


	public Integer getStatus() {
		return status;
	}


	public void setStatus(Integer status) {
		this.status = status;
	}


	public Integer getBusiType() {
		return busiType;
	}


	public void setBusiType(Integer busiType) {
		this.busiType = busiType;
	} 
    
}