package cn.gtmap.secondaryMarket.common.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @作者 王建明
 * @创建日期 2020/10/20 11:00
 * @描述
 */
@Entity
@Table(name = "SYS_FILE")
public class SysFile {
	@Id
	@Comment("文件主键")
	@Column(name = "COL_ID", columnDefinition = "VARCHAR2(32)")
	private String colId;
	@Comment("外部关联键值")
	@Column(name = "COL_FILE_KEY", columnDefinition = "VARCHAR2(200)")
	private String colFileKey;
	@Comment("文件名称")
	@Column(name = "COL_FILE_NAME", columnDefinition = "VARCHAR2(200)")
	private String colFileName;
	@Comment("文件大小")
	@Column(name = "COL_FILE_SIZE", columnDefinition = "NUMBER(18)")
	private long colFileSize;
	@Comment("上传时间")
	@Column(name = "COL_UPLOAD_TIME", columnDefinition = "DATE")
	private Date colUploadTime;
	@Comment("存储路径")
	@Column(name = "COL_STORE_PATH", columnDefinition = "VARCHAR2(200)")
	private String colStorePath;
	@Comment("父节点id")
	@Column(name = "COL_PARENT_ID", columnDefinition = "VARCHAR2(32)")
	private String colParentId;
	@Comment("文件类型（0文件夹；1文件）")
	@Column(name = "COL_FILE_TYPE", columnDefinition = "NUMBER(1)")
	private Integer colFileType;
	@Comment("文件描述")
	@Column(name = "COL_DESCRIPTION", columnDefinition = "VARCHAR2(200)")
	private String colDescription;

	public String getColId() {
		return colId;
	}

	public void setColId(String colId) {
		this.colId = colId;
	}

	public String getColFileKey() {
		return colFileKey;
	}

	public void setColFileKey(String colFileKey) {
		this.colFileKey = colFileKey;
	}

	public String getColFileName() {
		return colFileName;
	}

	public void setColFileName(String colFileName) {
		this.colFileName = colFileName;
	}

	public long getColFileSize() {
		return colFileSize;
	}

	public void setColFileSize(long colFileSize) {
		this.colFileSize = colFileSize;
	}

	public Date getColUploadTime() {
		return colUploadTime;
	}

	public void setColUploadTime(Date colUploadTime) {
		this.colUploadTime = colUploadTime;
	}

	public String getColStorePath() {
		return colStorePath;
	}

	public void setColStorePath(String colStorePath) {
		this.colStorePath = colStorePath;
	}

	public String getColParentId() {
		return colParentId;
	}

	public void setColParentId(String colParentId) {
		this.colParentId = colParentId;
	}

	public Integer getColFileType() {
		return colFileType;
	}

	public void setColFileType(Integer colFileType) {
		this.colFileType = colFileType;
	}

	public String getColDescription() {
		return colDescription;
	}

	public void setColDescription(String colDescription) {
		this.colDescription = colDescription;
	}
}
