package cn.gtmap.secondaryMarket.common.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * 短信状态表
 * @author gt
 *
 */
@Entity
@Table(name = "sms_code")
public class SmsCode {
	@Id
	@Column(length = 32)
	private String smsId;

	@Column(length = 32)
	private String code;

	@Temporal(TemporalType.TIMESTAMP)
	private Date createTime;
	
	@Temporal(TemporalType.TIMESTAMP)
	private Date expiredTime;

	public SmsCode(String smsId, String code, Date createTime, Date expiredTime) {
		super();
		this.smsId = smsId;
		this.code = code;
		this.createTime = createTime;
		this.expiredTime = expiredTime;
	}
	
	public SmsCode() {
		super();
	}

	public String getSmsId() {
		return smsId;
	}

	public void setSmsId(String smsId) {
		this.smsId = smsId;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Date getExpiredTime() {
		return expiredTime;
	}

	public void setExpiredTime(Date expiredTime) {
		this.expiredTime = expiredTime;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	
}
