package cn.gtmap.secondaryMarket.common.constants.sign;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;




/**
 * 消息常量
 *
 * @author <a href="mailto: lijian@gtmap.cn">lj</a>
 * @version 1.0 15-11-21
 */
public class Constants {
	public static final String SPLIT_STR = "$";
	
	public static final String SYS_TYPE_AUTH = "权限分配";

	//系统级常量
	public static final String SYS_HENGGANG = "-";//横杠
	
	//文件中心
	public static final String FOLDER_BUSI_YS_CAD = "CAD成果数据";//建设用地预审成果数据
	
	//项目类型
	public static final String XMLX_SZL = "市政类";//市政类
	public static final String XMLX_FSZL = "非市政类";//非市政类
	//行政区编码
	public static final String XZQ_BH_CZS = "320400";//常州市
	public static final String XZQ_BH_TN = "320402";//天宁
	public static final String XZQ_BH_ZL = "320404";//钟楼
	public static final String XZQ_BH_JK = "320491";//经开
	public static final String XZQ_BH_XB = "320411";//新北
	public static final String XZQ_BH_WJ = "320412";//武进

	//签章名称
	public static final String SIGN_NAME = "常州市自然资源和规划局";
	public static final String SIGN_CESHI = "测试专用章";

	//转发人
	public static final Map<String, String> ZFR = Collections.unmodifiableMap(new HashMap<String, String>() {
		private static final long serialVersionUID = 1L;
		{
			put("用地预审经办","CLD_JBYJ");
			put("利用审查","CLD_LYKYJ");
			put("林业和矿产管理","CLD_LYKYJ");
			put("地矿审查","CLD_KGKYJ");
			put("空间规划科","CLD_KGKYJ");
			put("耕保审查","CLD_GBKYJ");
			put("调查与确权登记科审查","CLD_GBKYJ");
			put("保护与修复科","CLD_GBKYJ");
			put("规划审查","CLD_SCYJ");
			put("保护与修复科意见","CLD_SCYJ");
			put("利用综合审查","CLD_SCYJ");
			put("分管领导审批","CLD_FGLDYJ");
			put("国土所所长签字","CLD_LDYJ");
			put("科长审核","CLD_KSYJ");
			put("分管局长审核","CLD_LDYJ");
		}
	});

	//流程定义id
	public static final Map<String, String> LCID = Collections.unmodifiableMap(new HashMap<String, String>() {
		private static final long serialVersionUID = 1L;
		{
			put("武进（两区经办）建设项目用地预审与选址意见书","BC780E97F6DE4FC0BE5AFC45CC9B3A39");
			put("经开建设项目用地预审与选址意见书","7B71342D31D24E08AD83BA46B33CCD3F");
			put("建设项目用地预审与选址意见书","7391205915CA4D838CDBB1330646AEA2");
			put("武进建设项目用地预审与选址意见书","4B4C18FDADF24338870C7949540B3EBF");
			put("新北（区）建设项目用地预审与选址意见书","6FD4FCD37E6F4E00870B498409B4A7E4");
			put("新北（镇）建设项目用地预审与选址意见书","DA35C3AF98574FDCAD03C3537B69DF20");
		}
	});
	//签名地址
	public static final Map<String, String> QMDZ = Collections.unmodifiableMap(new HashMap<String, String>() {
		private static final long serialVersionUID = 1L;
		{
			put("用地预审经办","用地预审经办意见");
			put("利用审查","供地审查意见");
			put("林业和矿产管理","供地审查意见");
			put("地矿审查","矿管审查意见");
			put("空间规划科","矿管审查意见");
			put("耕保审查","林业审查意见");
			put("调查与确权登记科审查","林业审查意见");
			put("保护与修复科","林业审查意见");
			put("规划审查","用地预审审核意见");
			put("保护与修复科意见","用地预审审核意见");
			put("利用综合审查","用地预审审核意见");
			put("分管领导审批","分管领导审定意见");
			put("国土所所长签字","领导意见");
			put("科长审核","科室意见");
			put("分管局长审核","领导意见");
//			put("选址审核（审定）","规划审定");
//			put("选址审定","规划审定");
		}
	});
 	//行政区编码对应的特有编号
	public static final Map<String, String> XZQ_BH_MAP = Collections.unmodifiableMap(new HashMap<String, String>() {
		private static final long serialVersionUID = 1L;
		{
			put(XZQ_BH_CZS, "0");
			put(XZQ_BH_TN, "1");
			put(XZQ_BH_ZL, "2");
			put(XZQ_BH_JK, "3");
			put(XZQ_BH_XB, "4");
			put(XZQ_BH_WJ, "5");
		}
	});

	//新北人员
	public static final String xbUser = "阮霞仙，钱秋立、吴佳晏";
	//武进人员
	public static final String wjUser = "包艳、屠平、李红、王强、张英、周平、周伟瑾、王叶露、贺金林、祁婷立";
	//经开人员
	public static final String jkUser = "韩丹、樊群";
}
