/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     Constants.java
 * Modifier: yangxin
 * Modified: 2014-06-11 22:33
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */
package cn.gtmap.secondaryMarket.common.constants;


import java.util.ResourceBundle;

/**
 * 常量
 * Created by trr on 2016-11-21.
 */
public class Constants {
    public static final String OpenOffice_HOME;
    public static final String host_Str;
    public static final String port_Str;

    static {
        ResourceBundle rb = ResourceBundle.getBundle("OpenOfficeService");
        OpenOffice_HOME = rb.getString("OO_HOME");
        host_Str = rb.getString("oo_host");
        port_Str = rb.getString("oo_port");
    }

    public static int strToInt(String str) {
        int i = 0;
        if (str != null && !"".equals(str)) {
            i = Integer.parseInt(str);
        }
        return i;
    }

    public static double strToDouble(String str) {
        double d = 0.0;
        if (str != null && !"".equals(str)) {
            d = Double.parseDouble(str);
        }
        return d;
    }
    /**
     * 是 否
     */
    public static class Whether {
        public static final Integer NO = 0;
        public static final Integer YES = 1;
    }


    /**
     * 用户类型
     */
    public static class UserType {
        public static final Short ADMIN = 0;
        public static final Short ORDINARY = 1;
    }

    /**
     * 模块层级
     */
    public static class MENU_LEAVE {

        public static final Short LEVEL_1 = 1;

        public static final Short LEVEL_2 = 2;

        public static final Short LEVEL_3 = 3;
    }

    /**
     * 事务超时时间
     */
    public static class TRANSACTIONAL {

        /**
         * 超时时间
         */
        public static final int TIMEOUT = 3600;

    }


    public enum TrialType{
        NONE_COMMIT_TRIAL("未提交审核"),
        COMMIT_TO_TRIAL("资格提交审核中"),
        PASSED_TRIAL("资格审核通过"),
        FAILED_TRIAL("资格审核失败");
        private String title;

        TrialType(String title) {
            this.title = title;
        }
    }


    /**
     * 数值常亮
     */
    public static class NumberValue {

        /**
         * 数值:0.
         */
        public static final int NUM_0 = 0;

        /**
         * 数值:1.
         */
        public static final int NUM_1 = 1;

        /**
         * 数值:2.
         */
        public static final int NUM_2 = 2;

        /**
         * 数值:3.
         */
        public static final int NUM_3 = 3;

        /**
         * 数值:6.
         */
        public static final int NUM_6 = 6;

        /**
         * 数值:8.
         */
        public static final int NUM_8 = 8;


        /**
         * 数值:10.
         */
        public static final int NUM_10 = 10;

        /**
         * 数值:11.
         */
        public static final int NUM_11 = 11;

        /**
         * 数值:11.
         */
        public static final int NUM_12 = 12;

        /**
         * 数值:11.
         */
        public static final int NUM_15 = 15;

        /**
         * 数值:1000.
         */
        public static final int NUM_1000 = 1000;

    }

    /**
     * 附件路径
     */
    public static class FILE_PATH {

        /**
         * 附件根目录
         */
        public static final String FILE_ROOT_PATH = "upload";

        /**
         * ckeditor路径
         */
        public static final String CKEDITOR_PATH = "upload/ckedit";

        /**
         * 卖地图片路径
         */
        public static final String SALE_IMG = "upload/saleImg";
    }

    /**
     * 我的收藏
     */
    public static class TDSC_FAVORITE {

        /**
         * 公告
         */
        public static final String GYGG = "1";

        /**
         * 公告地快
         */
        public static final String GGDK = "2";

        /**
         * 成交公示
         */
        public static final String CJGS = "3";

        /**
         * 供地項目
         */
        public static final String GDXM = "4";

        /**
         * 土地市場卖地
         */
        public static final String TDSC_S = "5";

        /**
         * 土地市場买地
         */
        public static final String TDSC_B = "6";
    }

    /**
     * 项目状态
     */
    public static class XMZT_LEAVE {

        /**
         * 审核通过
         */
        public static final String LEVEL_1 = "211";

        /**
         * 未审核
         */
        public static final String LEVEL_2 = "111";
    }

    /**
     * 用户类型
     */
    public static class USER_TYPE {

        public static final String ADMIN = "1";

        public static final String MEMBER = "2";

    }

    /**
     * 土地市场买卖地编号
     */
    public static class TDSC_BH {

        public static final String BUY = "B";

        public static final String SALE = "S";

    }

    /**
     * 土地市场卖地土地状态
     */
    public static class TDSC_TDZT {
        /**
         * 用户提交待审核
         */
        public static final Short CHECK_PENDING = 1;
        /**
         * 审核不通过
         */
        public static final Short NOT_PASS = 2;
        /**
         * 审核通过
         */
        public static final Short PASS = 3;
        /**
         * 成交
         */
        public static final Short DEAL = 4;

    }

    /**
     * 土地市场是否置顶
     */
    public static class SFZD {

        public static final String NOT_STICK = "0";

        public static final String STICK = "1";

    }

    /**
     * 是否
     */
    public static class ENABLE {

        public static final String NOT = "0";

        public static final String YES = "1";

    }

    /**
     * 土地市场浏览次数
     */
    public static class LLCS {

        public static final short NUMBER = 0;

    }

    /**
     * 未登录的用户
     */
    public static class ANONYMOUSUSER {
        public static final String ANONYMOUSUSER = "anonymousUser";
    }

    /**
     * 土地标签，是否允许编辑
     */
    public static class TDSCLABLE {
        public static final String NOT_EDIT = "0";
        public static final String EDIT = "1";
    }

    /**
     * es导入表名
     */
    public static class ES_TABLE_NAME {

        /**
         * t_Remise_Affiche
         */
        public static final String T_REMISE_AFFICHE = "T_REMISE_AFFICHE";

        /**
         * t_Affiche_Parcel
         */
        public static final String T_AFFICHE_PARCEL = "T_AFFICHE_PARCEL";

        /**
         * t_Bargain_Parcel
         */
        public static final String T_BARGAIN_PARCEL = "T_BARGAIN_PARCEL";

        /**
         * t_gdxm
         */
        public static final String T_GDXM = "T_GDXM";

        /**
         * t_Xwzx
         */
        public static final String T_XWZX = "T_XWZX";

        /**
         * t_Gyjh
         */
        public static final String T_GYJH = "T_GYJH";

        /**
         * t_jzdj
         */
        public static final String T_JZDJ = "T_JZDJ";

        /**
         * t_Jtjsyd_Gg
         */
        public static final String T_JTJSYD_GG = "T_JTJSYD_GG";

        /**
         *T_BCGDZB_GG
         */
        public static final String T_BCGDZB_GG = "T_BCGDZB_GG";

    }


    /**
     * es删除类型
     */
    public static class ES_DELETE_NAME {

        /**
         * t_Remise_Affiche
         */
        public static final String T_REMISE_AFFICHE = "TRemiseAffiche";

        /**
         * t_Affiche_Parcel
         */
        public static final String T_AFFICHE_PARCEL = "TAfficheParcel";

        /**
         * t_Bargain_Parcel
         */
        public static final String T_BARGAIN_PARCEL = "TBargainParcel";

        /**
         * t_gdxm
         */
        public static final String T_GDXM = "TGdxm";

        /**
         * t_Xwzx
         */
        public static final String T_XWZX = "TXwzx";

        /**
         * t_Gyjh
         */
        public static final String T_GYJH = "TGyjh";

        /**
         * t_jzdj
         */
        public static final String T_JZDJ = "TJzdj";

        /**
         * t_Jtjsyd_Gg
         */
        public static final String T_JTJSYD_GG = "TJtjsydGg";

        /**
         *T_BCGDZB_GG
         */
        public static final String T_BCGDZB_GG = "TBcgdzbGg";

        /**
         *T_BCGDZB_XWZX
         */
        public static final String T_BCGDZB_XWZX = "TBcgdzbXwzx";

        /**
         *T_BCGDZB_WJXZ
         */
        public static final String T_BCGDZB_WJXZ = "TBcgdzbWjxz";

    }

    /**
     * 信息返回Code
     */
    public static class MESSAGE_CODE {

        public static final String SUCCESS = "200";

        public static final String ERROR = "500";

        /**
         * 数据验证错误
         */
        public static final String ERROR_CHECK = "400";

    }

    /**
     * 不动产接口 返回数据
     */
    public static class BDC_INTERFACE {

        /**
         * 过渡查封
         */
        public static final String GDCF = "gdCf";

        /**
         * 过渡抵押
         */
        public static final String GDDY = "gdDy";

        /**
         * 不动产查封
         */
        public static final String BDCCF = "bdcCf";

        /**
         * 不动产抵押
         */
        public static final String BDCDY = "bdcDy";

        /**
         * 验证信息 分三种，验证成功、缺少参数、验证服务异常
         */
        public static final String MSG = "msg";

        public static final String VALID_SUCCESS = "验证成功！";

        public static final String EMPTY_ZH = "未查询到信息,请检查证号！";

    }

    /**
     * 中介类型
     */
    public static class ORGANIZATION_TYPE {
        //0表示中介机构
        public static final Short  INTERMEDIARY_AGENCY = 0;
        //1表示评估机构
        public static final Short ASSESSMENT_AGENCY = 1;

    }

    /**
     * 中介名称
     */
    public static class ORGANIZATION_NAME {
        //0表示中介机构
        public static final String  INTERMEDIARY_AGENCY = "中介机构";
        //1表示评估机构
        public static final String ASSESSMENT_AGENCY = "评估机构";

    }

    /**
     * 默认文件名称
     */
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";

    /**
     * 默认创建文件夹
     */
    public enum DEFAULT_FILE {
        BDCDJSQB("不动产登记申请表", "原件的复印件或照片"),
        DBCDJTDYJYSB("不动产登记土地要件预审表", "原件的复印件或照片"),
        WANYUAN_MU("不动产权属证书", "原件的复印件或照片"),
        BCXY("补充协议", "原件的复印件或照片"),
        BDCQJDC("不动产权籍调查、宗地图", "原件的复印件或照片"),
        SQWTS("授权委托书", "原件的复印件或照片"),
        YYZZ("营业执照", "原件的复印件或照片"),
        SFZM1("身份证正面", "原件的复印件或照片"),
        SFZM2("身份证反面", "原件的复印件或照片"),
        SQRYX("申请人影像", "原件的复印件或照片"),
        SJ("收据", "原件的复印件或照片"),
        WSZM("完税证明", "原件的复印件或照片"),
        HT("合同", "原件的复印件或照片");

        private String title;
        private String description;

        DEFAULT_FILE(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String toString() {
            return title;
        }
    }
    
    /**
     * 会员端 默认创建文件夹
     */
    public enum MEMBER_DEFAULT_FILE {
        WANYUAN_MU("不动产权属证书", "原件的复印件或照片"),
        SQWTS("授权委托书", "原件的复印件或照片"),
        YYZZ("营业执照", "原件的复印件或照片"),
        SFZM1("身份证正面", "原件的复印件或照片"),
        SFZM2("身份证反面", "原件的复印件或照片"),
        SQRYX("申请人影像", "原件的复印件或照片"),
        HT("合同", "原件的复印件或照片"),
        TZZM("投资证明", "原件的复印件或照片");

        private String title;
        private String description;

        MEMBER_DEFAULT_FILE(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public String toString() {
            return title;
        }
    }
    /**
     * 会员端 文件夹类型
     */
    public static final String MEMBER_FILE_TYPE_CONTRACT="HT";//合同
    public static final String MEMBER_FILE_TYPE_CONTRACT_DK="HT_DK";//地块文件夹
    
    /**
     * 会员端 合同附件创建文件夹
     */
    public enum MEMBER_CONTRACT_FILE {
    	BDCDJSQB("不动产登记申请表", "扫描件"),
    	BDCQSZSTDZ("不动产权属证书、土地证", "扫描件"),
    	BDCQJDCZDT("不动产权籍调查、宗地图", "扫描件"),
    	YYZZ("营业执照", "扫描件"),
    	SQWTS("授权委托书", "扫描件"),
    	SFZM1("身份证正面", "扫描件"),
    	SFZM2("身份证反面", "扫描件"),
    	SFZM3("身份证明", "扫描件"),
    	SQRYX("申请人影像", "照片"),
    	WSZM("完税证明（契税、印花税）", "扫描件"),
    	GJBGS("估价报告书", "扫描件"),
    	XMLXTZZMCL("项目立项投资证明材料", "扫描件"),
    	QTBYCL("其他必要材料", "扫描件"),
    	HT("合同（填写完后上传）", "扫描件");
    	
    	private String title;
    	private String description;
    	
    	MEMBER_CONTRACT_FILE(String title, String description) {
    		this.title = title;
    		this.description = description;
    	}
    	
    	public String getTitle() {
    		return title;
    	}
    	
    	public void setTitle(String title) {
    		this.title = title;
    	}
    	
    	public String getDescription() {
    		return description;
    	}
    	
    	public void setDescription(String description) {
    		this.description = description;
    	}
    	
    	@Override
    	public String toString() {
    		return title;
    	}
    }

    /**
     * 默认文件夹名称
     */
    public static final String DEFAULT_FILE_NAME = "新建文件夹";

    /**
     * 默认 材料类型
     */
    public static final String DEFAULT_DESCRIPTION = "原件的复印件或照片";


    /**
     * 中介名称
     */
    public static class BDC_RETURN_TYPE {

        //00表示证号不存在
        public static final String  TYPE_00 = "00";

        //01表示存在查封记录
        public static final String TYPE_01 = "01";

        //02表示存在抵押记录
        public static final String TYPE_02 = "02";

        //03表示验证成功
        public static final String TYPE_03 = "03";

        //04表示验证成功
        public static final String TYPE_04 = "验证失败";

    }

}
